% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_sar.R
\name{estimate_sar}
\alias{estimate_sar}
\title{Estimate Secondary Attack Rate of the Chain Binomial Model}
\usage{
estimate_sar(infected, s0, i0 = 1, generations = Inf, se = TRUE)
}
\arguments{
\item{infected}{numeric.}

\item{s0}{numeric.}

\item{i0}{numeric.}

\item{generations}{numeric.}

\item{se}{logical. If TRUE (default), the standard error is computed.}
}
\value{
A list of class \code{sar} with the following components:
\itemize{
\item \code{sar_hat} The point estimate of the secondary attack rate.
\item \code{se} Standard error of the estimate (if se = TRUE).
\item \code{loglikelihood} The log likelihood value at the point estimate.
\item \code{data} The input data.
}
}
\description{
Given data on the number of infected after a number of generation, initial
number of susceptible, and initial number of infected, estimate the
secondary attack rate (SAR) using maximum likelihood.
}
\examples{
set.seed(234)
mydata <- rchainbinom(n = 15, s0 = 5, sar = 0.2, i0 = 1, generations = Inf)
res <- estimate_sar(infected = mydata, s0 = 5, i0 = 1, generations = Inf)

}
\seealso{
\code{\link[=confint.sar]{confint.sar()}} for calculating confidence intervals.
}
