% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_loglik_methods.R
\name{update.chantrics}
\alias{update.chantrics}
\title{Update, re-fit and re-adjust a Model Call}
\usage{
\method{update}{chantrics}(object, ...)
}
\arguments{
\item{object}{A \code{"chantrics"} returned by \code{\link[=adj_loglik]{adj_loglik()}}.}

\item{...}{Additional arguments to the call, passed to \code{\link[stats:update]{stats::update()}} to
update the original model specification.}
}
\value{
The fitted, adjusted \code{"chantrics"} object.
}
\description{
\code{update.chantrics()} will update a model that has been adjusted by
\code{\link[=adj_loglik]{adj_loglik()}}. It passes all arguments to the standard \code{\link[stats:update]{stats::update()}}
function.
}
\details{
The function cannot change any arguments passed to the \code{adj_loglik()}
function. To change any of these arguments, re-run \code{adj_loglik()}.

Passing \code{evaluate = FALSE} is not supported, if this is required,
run \code{\link[stats:update]{stats::update()}} on the unadjusted object.
}
\examples{
# from Introducing Chandwich.
set.seed(123)
x <- rnorm(250)
y <- rnbinom(250, mu = exp(1 + x), size = 1)
fm_pois <- glm(y ~ x + I(x^2), family = poisson)
fm_pois_adj <- adj_loglik(fm_pois)
fm_pois_small_adj <- update(fm_pois_adj, formula = . ~ . - I(x^2))
summary(fm_pois_small_adj)
fm_pois_smallest_adj <- update(fm_pois_adj, formula = . ~ 1)
summary(fm_pois_smallest_adj)
}
\seealso{
\code{\link[stats:update]{stats::update()}}

\code{\link[stats:update.formula]{stats::update.formula()}}
}
