% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize}
\alias{summarize}
\alias{summarise}
\title{Summarize color classification results}
\usage{
summarize(charisma_obj)

summarise(charisma_obj)
}
\arguments{
\item{charisma_obj}{A charisma object (output from \code{\link{charisma}}
or \code{\link{charisma2}}) containing color classification results.}
}
\value{
A data frame with one row per image showing the proportion of pixels
assigned to each color category. Row names are set to the basename of the
image file path.
}
\description{
This function takes a charisma object and produces a summary table showing
the proportion of pixels classified into each discrete color category.
}
\details{
The summary table shows the percentage of pixels classified into each of the
discrete color categories defined in the Color Look-Up Table (CLUT). This
provides a quantitative overview of the color composition of the analyzed
image.
}
\examples{
\donttest{
# Run charisma on an image
img <- system.file("extdata", "Tangara_fastuosa_LACM60421.png",
                   package = "charisma")
result <- charisma(img)

# Summarize the color classification results
summary_table <- summarize(result)
print(summary_table)
}

}
\seealso{
\code{\link{charisma}} for the main classification pipeline,
\code{\link{validate}} for CLUT validation
}
