# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/person/person/__init___cs_cz.py

person_formats_cs_cz <- c(
  "{{first_names_male}} {{last_names_male}}",
  "{{first_names_male}} {{last_names_male}}",
  "{{first_names_male}} {{last_names_male}}",
  "{{first_names_male}} {{last_names_male}}",
  "{{first_names_male}} {{last_names_male}}",
  "{{first_names_female}} {{last_names_female}}",
  "{{first_names_female}} {{last_names_female}}",
  "{{first_names_female}} {{last_names_female}}",
  "{{first_names_female}} {{last_names_female}}",
  "{{first_names_female}} {{last_names_female}}",
  "{{prefixes_male}} {{first_names_male}} {{last_names_male}}",
  "{{prefixes_female}} {{first_names_female}} {{last_names_female}}",
  "{{first_names_male}} {{last_names_male}} {{suffixes}}",
  "{{first_names_female}} {{last_names_female}} {{suffixes}}",
  "{{prefixes_male}} {{first_names_male}} {{last_names_male}} {{suffixes}}",
  "{{prefixes_female}} {{first_names_female}} {{last_names_female}} {{suffixes}}"
)

person_first_names_male_cs_cz <- c(
  "Adam",
  "Alexander",
  "Alexandr",
  "Ale\u0161",
  "Alois",
  "Anton\u00edn",
  "Arno\u0161t",
  "Bed\u0159ich",
  "Bohumil",
  "Bohum\u00edr",
  "Bohuslav",
  "B\u0159etislav",
  "Dalibor",
  "Daniel",
  "David",
  "Denis",
  "Dominik",
  "Du\u0161an",
  "Eduard",
  "Emil",
  "Erik",
  "Filip",
  "Franti\u0161ek",
  "Hynek",
  "Igor",
  "Ivan",
  "Ivo",
  "Jakub",
  "Jan",
  "Jarom\u00edr",
  "Jaroslav",
  "Jind\u0159ich",
  "Ji\u0159\u00ed",
  "Josef",
  "Jozef",
  "J\u00e1n",
  "Kamil",
  "Karel",
  "Kry\u0161tof",
  "Ladislav",
  "Leo\u0161",
  "Libor",
  "Lubom\u00edr",
  "Lubo\u0161",
  "Ludv\u00edk",
  "Lud\u011bk",
  "Luk\u00e1\u0161",
  "Marcel",
  "Marek",
  "Marian",
  "Martin",
  "Maty\u00e1\u0161",
  "Mat\u011bj",
  "Michael",
  "Michal",
  "Milan",
  "Miloslav",
  "Milo\u0161",
  "Miroslav",
  "Old\u0159ich",
  "Ond\u0159ej",
  "Otakar",
  "Patrik",
  "Pavel",
  "Peter",
  "Petr",
  "P\u0159emysl",
  "Radek",
  "Radim",
  "Radom\u00edr",
  "Radovan",
  "Ren\u00e9",
  "Richard",
  "Robert",
  "Robin",
  "Roman",
  "Rostislav",
  "Rudolf",
  "Samuel",
  "Stanislav",
  "Tade\u00e1\u0161",
  "Tom\u00e1\u0161",
  "Vasyl",
  "Viktor",
  "Vil\u00e9m",
  "Vladim\u00edr",
  "Vladislav",
  "Vlastimil",
  "Vojt\u011bch",
  "Vratislav",
  "V\u00e1clav",
  "V\u00edt",
  "V\u00edt\u011bzslav",
  "Zbyn\u011bk",
  "Zden\u011bk",
  "\u0160imon",
  "\u0160tefan",
  "\u0160t\u011bp\u00e1n"
)

person_first_names_female_cs_cz <- c(
  "Ad\u00e9la",
  "Alena",
  "Alexandra",
  "Alice",
  "Al\u017eb\u011bta",
  "Andrea",
  "Aneta",
  "Ane\u017eka",
  "Anna",
  "Barbora",
  "Blanka",
  "Bla\u017eena",
  "Bohumila",
  "Bo\u017eena",
  "Dagmar",
  "Dana",
  "Daniela",
  "Danu\u0161e",
  "Denisa",
  "Dominika",
  "Drahom\u00edra",
  "Eli\u0161ka",
  "Emilie",
  "Eva",
  "Franti\u0161ka",
  "Gabriela",
  "Hana",
  "Helena",
  "Ilona",
  "Irena",
  "Iva",
  "Ivana",
  "Iveta",
  "Jana",
  "Jarmila",
  "Jaroslava",
  "Jind\u0159i\u0161ka",
  "Jitka",
  "Ji\u0159ina",
  "Julie",
  "Kamila",
  "Karol\u00edna",
  "Kate\u0159ina",
  "Kl\u00e1ra",
  "Kristina",
  "Krist\u00fdna",
  "Kv\u011bta",
  "Kv\u011btoslava",
  "Ladislava",
  "Lenka",
  "Libu\u0161e",
  "Lucie",
  "Ludmila",
  "Magdalena",
  "Magdal\u00e9na",
  "Marcela",
  "Marie",
  "Mark\u00e9ta",
  "Marta",
  "Martina",
  "Michaela",
  "Milada",
  "Milena",
  "Miloslava",
  "Milu\u0161e",
  "Miroslava",
  "Monika",
  "M\u00e1ria",
  "Nad\u011b\u017eda",
  "Nat\u00e1lie",
  "Nela",
  "Nikol",
  "Nikola",
  "Olga",
  "Pavla",
  "Pavl\u00edna",
  "Petra",
  "Radka",
  "Renata",
  "Ren\u00e1ta",
  "Romana",
  "R\u016f\u017eena",
  "Sabina",
  "Simona",
  "So\u0148a",
  "Stanislava",
  "S\u00e1ra",
  "Tereza",
  "Vendula",
  "Veronika",
  "Viktorie",
  "Vladim\u00edra",
  "Vlasta",
  "V\u011bra",
  "Zdenka",
  "Zde\u0148ka",
  "Zuzana",
  "\u0160t\u011bp\u00e1nka",
  "\u0160\u00e1rka",
  "\u017daneta"
)

person_first_names_cs_cz <- c(person_first_names_male_cs_cz, person_first_names_female_cs_cz)

person_last_names_male_cs_cz <- c(
  "Barto\u0161",
  "Bene\u0161",
  "Bla\u017eek",
  "Bl\u00e1ha",
  "Dole\u017eal",
  "Du\u0161ek",
  "Dvo\u0159\u00e1k",
  "Fiala",
  "Holub",
  "Hor\u00e1k",
  "H\u00e1jek",
  "Jel\u00ednek",
  "Kadlec",
  "Kol\u00e1\u0159",
  "Kopeck\u00fd",
  "Kratochv\u00edl",
  "Krej\u010d\u00ed",
  "Kr\u00e1l",
  "Ku\u010dera",
  "K\u0159\u00ed\u017e",
  "Mal\u00fd",
  "Marek",
  "Mare\u0161",
  "Ma\u0161ek",
  "Moravec",
  "Novotn\u00fd",
  "Nov\u00e1k",
  "N\u011bmec",
  "Pokorn\u00fd",
  "Pol\u00e1k",
  "Posp\u00ed\u0161il",
  "Proch\u00e1zka",
  "R\u016f\u017ei\u010dka",
  "Sedl\u00e1\u010dek",
  "Soukup",
  "Svoboda",
  "Urban",
  "Van\u011bk",
  "Vesel\u00fd",
  "Vl\u010dek",
  "Zeman",
  "\u010cerm\u00e1k",
  "\u010cern\u00fd",
  "\u0158\u00edha",
  "\u0160imek",
  "\u0160t\u011bp\u00e1nek",
  "\u0160\u0165astn\u00fd"
)

person_last_names_female_cs_cz <- c(
  "Barto\u0161ov\u00e1",
  "Bene\u0161ov\u00e1",
  "Beranov\u00e1",
  "Bla\u017ekov\u00e1",
  "Bl\u00e1hov\u00e1",
  "Dole\u017ealov\u00e1",
  "Du\u0161kov\u00e1",
  "Dvo\u0159\u00e1kov\u00e1",
  "Fialov\u00e1",
  "Holubov\u00e1",
  "Hor\u00e1kov\u00e1",
  "H\u00e1jkov\u00e1",
  "Jandov\u00e1",
  "Jel\u00ednkov\u00e1",
  "Kadlecov\u00e1",
  "Kol\u00e1\u0159ov\u00e1",
  "Kopeck\u00e1",
  "Kratochv\u00edlov\u00e1",
  "Krej\u010dov\u00e1",
  "Kr\u00e1lov\u00e1",
  "Ku\u010derov\u00e1",
  "K\u0159\u00ed\u017eov\u00e1",
  "Machov\u00e1",
  "Mal\u00e1",
  "Mare\u0161ov\u00e1",
  "Markov\u00e1",
  "Ma\u0161kov\u00e1",
  "Moravcov\u00e1",
  "Novotn\u00e1",
  "Nov\u00e1kov\u00e1",
  "N\u011bmcov\u00e1",
  "Pokorn\u00e1",
  "Pol\u00e1kov\u00e1",
  "Posp\u00ed\u0161ilov\u00e1",
  "Proch\u00e1zkov\u00e1",
  "R\u016f\u017ei\u010dkov\u00e1",
  "Sedl\u00e1\u010dkov\u00e1",
  "Soukupov\u00e1",
  "Svobodov\u00e1",
  "Tich\u00e1",
  "Urbanov\u00e1",
  "Vackov\u00e1",
  "Va\u0148kov\u00e1",
  "Vesel\u00e1",
  "Vl\u010dkov\u00e1",
  "V\u00e1vrov\u00e1",
  "Zemanov\u00e1",
  "\u010cerm\u00e1kov\u00e1",
  "\u010cern\u00e1",
  "\u0158\u00edhov\u00e1",
  "\u0160imkov\u00e1",
  "\u0160t\u011bp\u00e1nkov\u00e1",
  "\u0160\u0165astn\u00e1"
)

person_last_names_cs_cz <- c(person_last_names_male_cs_cz, person_last_names_female_cs_cz)

person_degrees_cs_cz <- c("JUDr.", "Ing.", "Bc.", "Mgr.", "MUDr.", "RNDr.")

person_prefixes_male_cs_cz <- c("pan", person_degrees_cs_cz)

person_prefixes_female_cs_cz <- c("pan\u00ed", "sle\u010dna", person_degrees_cs_cz)

person_suffixes_cs_cz <- c("CSc.", "DiS.", "Ph.D.", "Th.D.")

person_cs_cz <- list(
  first_names = person_first_names_cs_cz,
  first_names_male = person_first_names_male_cs_cz,
  first_names_female = person_first_names_female_cs_cz,
  last_names_male = person_last_names_male_cs_cz,
  last_names_female = person_last_names_female_cs_cz,
  last_names = c(person_last_names_male_cs_cz, person_last_names_female_cs_cz),
  prefixes_female = person_prefixes_female_cs_cz,
  prefixes_male = person_prefixes_male_cs_cz,
  suffixes = person_suffixes_cs_cz
)

#' @title Person Provider for Czech (Czech Republic)
#' @inherit PersonProvider description details return
#' @export
#' @family cs
#' @family CZ
#' @details Note for female and male components that we fall back on generic
#' versions if the locale
#' doesn't provide a male/female version.
#' e.g., if no female first name we use first
#' name
#' @examples
#' x <- PersonProvider_cs_CZ$new()
#' x$locale
#' x$render()
#' x$first_name()
#' x$first_name_female()
#' x$first_name_male()
#' x$last_name()
#' x$last_name_female()
#' x$last_name_male()
PersonProvider_cs_CZ <- R6::R6Class(
  "PersonProvider_cs_CZ",
  inherit = PersonProvider,
  private = list(
    # person name formats
    formats = person_formats_cs_cz,
    # person name data
    persons = person_cs_cz,
    locale_ = "cs_CZ"
  )
)
