% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transactions.R
\name{get_transactions}
\alias{get_transactions}
\title{Get Account Transactions}
\usage{
get_transactions(
  tokens,
  encrypted_account_id,
  start_datetime = strftime(Sys.time() - lubridate::days(180), format =
    "\%Y-\%m-\%dT\%H:\%M:\%OS3Z"),
  end_datetime = strftime(Sys.time(), format = "\%Y-\%m-\%dT\%H:\%M:\%OS3Z"),
  symbol = NULL,
  types = NULL
)
}
\arguments{
\item{tokens}{token object from `get_authentication_tokens` function (list).}

\item{encrypted_account_id}{encrypted ID of the account from `get_account_numbers` function (string).}

\item{start_datetime}{datetime that you would like to start gathering transactions from, in yyyy-mm-dd'T'HH:mm:ss.SSSZ format. Default is current datetime less 180 days (string).}

\item{end_datetime}{datetime that you would like to end gathering transactions from, in yyyy-mm-dd'T'HH:mm:ss.SSSZ format. Default is current datetime (string).}

\item{symbol}{filter for transactions based on this symbol. Default is NULL, which means no filtering (string).}

\item{types}{filter for transactions based on its type. Default is NULL, which means no filtering. Available values are 'TRADE', 'RECEIVE_AND_DELIVER', 'DIVIDEND_OR_INTEREST', 'ACH_RECEIPT', 'ACH_DISBURSEMENT', 'CASH_RECEIPT', 'CASH_DISBURSEMENT', 'ELECTRONIC_FUND', 'WIRE_OUT', 'WIRE_IN', 'JOURNAL', 'MEMORANDUM', 'MARGIN_CALL', 'MONEY_MARKET', or 'SMA_ADJUSTMENT' (string or character vector).}
}
\value{
Returns a data frame containing the account's transaction
        information.
}
\description{
Given the tokens object from the `get_authentication_tokens`
function and the encrypted ID for the account number of interest, get
the transactions associated with that account number. By
default, the last 180 days worth of transactions are returned.
However, this can be tweaked according to the date parameters
along with the types of transactions using the types parameter, but
the maximum date range is one year.
}
\details{
The easiest way to enter the right strings in the start/end times is to
begin with `Sys.time()`, use the `lubridate` package to adjust it, and
then format it as `%Y-%m-%dT%H:%M:%S.000Z`. For example, to get the current
date less 30 days, you can use:
`strftime(Sys.time() - lubridate::days(30), format = "%Y-%m-%dT%H:%M:%S.000Z")`.
The defaults for this function illustrate the appropriate usage for the API.
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, June 2024
}
\keyword{account}
\keyword{transactions}
