% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocreateFunction4R.R
\name{autocreateFunction4R}
\alias{autocreateFunction4R}
\title{autocreateFunction4R (development / experimental)}
\usage{
autocreateFunction4R(
  Func_description,
  packages = "base",
  Model = "gpt-5-nano",
  temperature = 1,
  View = TRUE,
  roxygen = TRUE,
  api_key = Sys.getenv("OPENAI_API_KEY"),
  verbose = TRUE
)
}
\arguments{
\item{Func_description}{A character string that describes the function to be generated.}

\item{packages}{A character string that specifies the packages to be used in the function.
Default is "base".}

\item{Model}{A character string that specifies the AI model to use. Default is "gpt-5-nano".}

\item{temperature}{A numeric value that controls the randomness of the AI model's output.
Higher values (e.g., 1.0) make output more random, lower values (e.g., 0.3) make it more
focused and deterministic. Default is 1. IMPORTANT: When using "gpt-5-nano",
temperature MUST be set to 1.}

\item{View}{A logical that indicates whether to view the intermediate steps.
Default is TRUE.}

\item{roxygen}{A logical that indicates whether to include roxygen comments
in the generated function. Default is TRUE.}

\item{api_key}{A character string that represents the API key for the AI model being used.
Default is the "OPENAI_API_KEY" environment variable.}

\item{verbose}{A logical flag to print the message Default is TRUE.}
}
\value{
The function returns a character string that represents the generated and improved R function.
}
\description{
This function generates an R function based on a given description,
proposes improvements, and then generates an improved version of the function.
It uses an AI model (OpenAI GPT) with robust prompts to ensure clean R code output.
This is an experimental function.
}
\details{
Generate and Improve R Functions (experimental)
}
\examples{
\dontrun{
  # Example 1: Basic usage with default settings
  Sys.setenv(OPENAI_API_KEY = "<APIKEY>")
  autocreateFunction4R(Func_description = "identify 2*n+3 sequence",  Model = "gpt-5-mini")

  # Example 2: Generate function using specific packages
  autocreateFunction4R(
    Func_description = "create a data frame with random numbers",
    Model = "gpt-5-mini", packages = "dplyr, tidyr"
  )
}
}
\author{
Satoshi Kume
}
