#' ChatGPT: Create Unit Tests
#'
#' Create `{testthat}` test cases for the code.
#'
#' @param code The code for which to create unit tests by ChatGPT. If not provided, it will use
#'   what's copied on the clipboard.
#'
#' @examples
#' \dontrun{
#' cat(create_unit_tests("squared_numbers <- function(numbers) {\n  numbers ^ 2\n}"))
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
create_unit_tests <- function(code = clipr::read_clip(allow_non_interactive = TRUE)) {
  code <- paste(gsub('"', "'", code), collapse = "\n")
  prompt <- paste0(
    "Using testthat 3e, version over 3.0.0, create a full testthat file, with test cases for the ",
    'following R code: "', code, '"'
  )
  parse_response(gpt_get_completions(prompt))
}
