% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isStrictlyNegativeNumberVector.R
\name{isStrictlyNegativeNumberVector}
\alias{isStrictlyNegativeNumberVector}
\title{Wrapper for the checkarg function, using specific parameter settings.}
\usage{
isStrictlyNegativeNumberVector(argument, default = NULL, stopIfNot = FALSE,
  n = NA, message = NULL, argumentName = NULL)
}
\arguments{
\item{argument}{See checkarg function.}

\item{default}{See checkarg function.}

\item{stopIfNot}{See checkarg function.}

\item{n}{See checkarg function.}

\item{message}{See checkarg function.}

\item{argumentName}{See checkarg function.}
}
\value{
See checkarg function.
}
\description{
This function can be used in 3 ways:\enumerate{
  \item Return TRUE or FALSE depending on whether the argument checks are
     passed. This is suitable e.g. for if statements that take further action
     if the argument does not pass the checks.\cr
  \item Throw an exception if the argument does not pass the checks. This is
     suitable e.g. when no further action needs to be taken other than
     throwing an exception if the argument does not pass the checks.\cr
  \item Same as (2) but by supplying a default value, a default can be assigned
     in a single statement, when the argument is NULL. The checks are still
     performed on the returned value, and an exception is thrown when not
     passed.\cr
}
}
\details{
Actual call to checkarg: checkarg(argument, "N", default = default, stopIfNot = stopIfNot, nullAllowed = FALSE, n = NA, zeroAllowed = FALSE, negativeAllowed = TRUE, positiveAllowed = FALSE, nonIntegerAllowed = TRUE, naAllowed = FALSE, nanAllowed = FALSE, infAllowed = FALSE, message = message, argumentName = argumentName)
}
\examples{
isStrictlyNegativeNumberVector(-2)
   # returns TRUE (argument is valid)
isStrictlyNegativeNumberVector("X")
   # returns FALSE (argument is invalid)
#isStrictlyNegativeNumberVector("X", stopIfNot = TRUE)
   # throws exception with message defined by message and argumentName parameters
isStrictlyNegativeNumberVector(-2, default = -1)
   # returns -2 (the argument, rather than the default, since it is not NULL)
#isStrictlyNegativeNumberVector("X", default = -1)
   # throws exception with message defined by message and argumentName parameters
isStrictlyNegativeNumberVector(NULL, default = -1)
   # returns -1 (the default, rather than the argument, since it is NULL)

}
