library(checkargs)
context("isStringVector")

test_that("isStringVector works for all arguments", {
  expect_identical(isStringVector(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector("", stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isStringVector("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isStringVector(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isStringVector(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isStringVector(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isStringVector(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(0, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isStringVector("", stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isStringVector("X", stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isStringVector(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isStringVector(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isStringVector(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isStringVector(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
})
