library(checkargs)
context("isZeroScalar")

test_that("isZeroScalar works for all arguments", {
  expect_identical(isZeroScalar(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isZeroScalar(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroScalar(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isZeroScalar(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isZeroScalar(0, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isZeroScalar(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar("X", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroScalar(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
