% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node.R
\name{geom_node}
\alias{geom_node}
\title{Highlight a node on a chessboard}
\usage{
geom_node(nodes, focus)
}
\arguments{
\item{nodes}{a \code{data.frame} with (at least) the following three columns:
\code{node}, \code{transect}, and \code{quadrats}. Must be the output if the function
\code{\link[=create_node_labels]{create_node_labels()}}.}

\item{focus}{an \code{character} of length 1. The node label to be emphasized on
the chessboard. Must exist in the \code{nodes} object.}
}
\value{
A list of two \code{geom_point} that must be added to a \code{ggplot2} object.
}
\description{
Highlights a node (cell) on a chessboard plotted with \code{\link[=gg_chessboard]{gg_chessboard()}}.
}
\examples{
library("chessboard")

# Two-dimensional sampling ----
sites_infos <- expand.grid("transect" = 1:3, "quadrat" = 1:5)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")

gg_chessboard(nodes) +
  geom_node(nodes, "2-3")

# One-dimensional sampling (only transects) ----
sites_infos <- data.frame("transect" = 1:5)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect")

gg_chessboard(nodes) +
  geom_node(nodes, "3-1")
}
