% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_to_edge_list.R
\name{matrix_to_edge_list}
\alias{matrix_to_edge_list}
\title{Convert an connectivity matrix to an edge list}
\usage{
matrix_to_edge_list(x, all = FALSE)
}
\arguments{
\item{x}{a \code{matrix} object. The connectivity matrix to be converted in an
edge list.}

\item{all}{a \code{logical} value. If \code{FALSE} (default), removes missing edges.}
}
\value{
A \code{data.frame} with two (or three) columns:
\itemize{
\item \code{from}: label of one of the two nodes of the edge
\item \code{to}: label of the other node of the edge
\item \code{edge}: 0 (no edge) or 1 (edge). This column is returned only if
\code{all = TRUE}.
}
}
\description{
Converts a connectivity matrix to an edge list. This function allows to
create the same edge list as the one obtained with \code{\link[=create_edge_list]{create_edge_list()}}.
}
\examples{
library("chessboard")

# Two-dimensional sampling ----
sites_infos <- expand.grid("transect" = 1:3, "quadrat" = 1:5)
sites_infos

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")

edges <- create_edge_list(nodes, method = "pawn", directed = TRUE)

conn_matrix <- connectivity_matrix(edges)

# Convert back to edge list ----
new_edges <- matrix_to_edge_list(conn_matrix)
new_edges

# Check ----
identical(edges, new_edges)
}
