% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invchi.R
\name{invchi}
\alias{invchi}
\alias{dinvchi}
\alias{pinvchi}
\alias{qinvchi}
\alias{rinvchi}
\title{The Inverse Chi Distribution}
\usage{
dinvchi(x, df, ncp = 0, log = FALSE)

pinvchi(q, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

qinvchi(p, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

rinvchi(n, df, ncp = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{df}{degrees of freedom (non-negative, but can be
non-integer).}

\item{ncp}{non-centrality parameter (non-negative).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as 
log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x] otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is 
taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random 
generation for the inverse chi distribution.
}
\examples{

s <- seq(0, 2, .01)
plot(s, dinvchi(s, 7), type = 'l')

f <- function(x) dinvchi(x, 7)
q <- .5
integrate(f, 0, q)
(p <- pinvchi(q, 7))
qinvchi(p, 7) # = q
mean(rinvchi(1e5, 7) <= q)


samples <- rinvchi(1e5, 7)
plot(density(samples))
curve(f, add = TRUE, col = "red")


}
\seealso{
\code{\link{dchi}}
}
