% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admin1.R
\docType{data}
\name{admin1.map}
\alias{admin1.map}
\title{An Administrative Level 1 map of every country in the world}
\usage{
data(admin1.map)
}
\description{
"Administration Level 1" is the generic term for the largest subnational administrative unit of a country. This
unit has different names depending on the country: for example, "state" in the USA and 
"prefecture" in Japan. In this data.frame the country name is in the column 
"admin" and the admin1 region name is in the column "region". Rather than working with this 
object directly, consider using the helper functions listed below.
}
\note{
This map is too large to efficiently render by itself with ggplot2. You should subset it by country before
attempting to render. Please see the helper functions.
}
\references{
Taken from http://www.naturalearthdata.com/downloads/10m-cultural-vectors/10m-admin-1-states-provinces/. 
This is version 3.0.0 of the map and is considered to be beta.
The wikipedia page on "Administrative division": http://en.wikipedia.org/wiki/Administrative_division
}
\seealso{
\code{\link{admin1.regions}}, \code{\link{get_admin1_regions}}, \code{\link{admin1_map}} and \code{\link{get_admin1_map}}
}
