% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_asm.R
\name{read_asm}
\alias{read_asm}
\title{Read 'Allotrope Simple Model' (ASM) 2D chromatograms}
\usage{
read_asm(
  path,
  data_format = c("wide", "long"),
  format_out = c("matrix", "data.frame", "data.table"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  collapse = TRUE
)
}
\arguments{
\item{path}{Path to ASM \code{.json} file.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{format_out}{Matrix or data.frame.}

\item{read_metadata}{Logical. Whether to attach metadata.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{collapse}{Logical. Whether to collapse lists that only contain a single
element. Defaults to \code{TRUE}.}
}
\value{
A 2D chromatogram in the format specified by \code{data_format} and
\code{format_out}. If \code{data_format} is \code{wide}, the chromatogram will
be returned with retention times as rows and a single column for the intensity.
If \code{long} format is requested, two columns will be returned: one for the
retention time and one for the intensity. The \code{format_out} argument
determines whether the chromatogram is returned as a \code{matrix} or
\code{data.frame}. Metadata can be attached to the chromatogram as
\code{\link{attributes}} if \code{read_metadata} is \code{TRUE}.
}
\description{
Reads \href{https://www.allotrope.org/asm}{'Allotrope Simple Model'} files into R.
}
\author{
Ethan Bass
}
