% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_to_partition.R
\name{DAGtoPartition}
\alias{DAGtoPartition}
\title{Convert DAG to partition}
\usage{
DAGtoPartition(dag)
}
\arguments{
\item{dag}{A directed acyclic graph represented as an adjacency matrix,
igraph, or bnlearn object.}
}
\value{
Labelled partition for the given adjacency matrix.
}
\description{
This converts a DAG to it's partition by iteratively constructing sets of
outpoints. This is further explained in section 4.1 of Kuipers & Moffa (2017).
}
\examples{
dag <- UniformlySampleDAG(LETTERS[1:3])
partitioned_nodes <- DAGtoPartition(dag)

}
\references{
Kuipers, J., & Moffa, G. (2017). Partition MCMC for inference on
acyclic digraphs. Journal of the American Statistical Association, 112(517),
282-299.
}
