% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie-comorbid.R
\name{cie_comorbid}
\alias{cie_comorbid}
\title{Calcular comorbilidades Charlson/Elixhauser para Chile}
\usage{
cie_comorbid(data, id, code, map = c("charlson", "elixhauser"), assign0 = TRUE)
}
\arguments{
\item{data}{data.frame con columnas id paciente + codigos CIE-10}

\item{id}{String nombre columna identificador paciente}

\item{code}{String nombre columna con codigos CIE-10 (uno por fila)}

\item{map}{Character, esquema comorbilidad ("charlson" o "elixhauser")}

\item{assign0}{Logical, asignar 0 si sin comorbilidad (default TRUE)}
}
\value{
data.frame ancho con scores comorbilidad por paciente
}
\description{
Calcular comorbilidades Charlson/Elixhauser para Chile
}
\examples{
\dontrun{
df <- data.frame(
  id_pac = c(1, 1, 2, 2),
  diag = c("E11.0", "I21.0", "C50.9", "E10.9")
)
cie_comorbid(df, id = "id_pac", code = "diag", map = "charlson")
}
}
