% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{circ_corr}
\alias{circ_corr}
\title{Circular correlation coefficient}
\usage{
circ_corr(a, b, ill_defined = FALSE, mu = NULL, na.rm = FALSE)
}
\arguments{
\item{a}{first variable}

\item{b}{second variable}

\item{ill_defined}{is one of the variables mean is not well-defined (e.g., it is uniformly distributed)?}

\item{mu}{fix the mean parameter of both vectors to a certain value}

\item{na.rm}{a logical value indicating whether NA values should be removed before the computation proceeds}
}
\value{
correlation coefficient
}
\description{
Computes a circular correlation coefficient as defined in Jammalamadaka & SenGupta (2001).
}
\examples{
requireNamespace("mgcv")
data <- mgcv::rmvn(10000, c(0, 0), V = matrix(c(1, 0.5, 0.5, 1), ncol = 2))
circ_corr(data[, 1], data[, 2])
}
\references{
{
Jammalamadaka, S. R., & SenGupta, A. (2001). Topics in Circular Statistics. WORLD SCIENTIFIC. \doi{10.1142/4031}
}
}
