% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccArrow}
\alias{ccArrow}
\title{Draw an arrow}
\usage{
ccArrow(
  x1,
  x2,
  y,
  width,
  arrow.head.length = NULL,
  arrow.head.width = width * 2,
  arrow.position = c("end", "start"),
  tail = c("normal", "point"),
  border = "black",
  col = "#FFCCCC",
  lty = par("lty"),
  ...
)
}
\arguments{
\item{x1}{Start position of the arrow on the x-axis.}

\item{x2}{End position of the arrow on the x-axis. Note \code{x2} should be larger than \code{x1}. The direction of arrows can be controlled by \code{arrow.position} argument.}

\item{y}{Position of the arrow on the y-axis. Note this is the center of the arrow on y-axis.}

\item{width}{Width of the arrow body.}

\item{arrow.head.length}{Length of the arrow head. Note the value should be smaller than the length of the arrow itself (which is \code{x2 - x1}).}

\item{arrow.head.width}{Width of the arrow head.}

\item{arrow.position}{Where is the arrow head on the arrow. If you want to the arrow in the reversed direction, set this value to \code{"start"}.}

\item{tail}{The shape of the arrow tail (the opposite side of arrow head).}

\item{border}{Border color of the arrow.}

\item{col}{Filled color of the arrow.}

\item{lty}{Line style of the arrow.}

\item{...}{Pass to \code{\link[graphics]{polygon}}.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.arrow]{circlize::circos.arrow} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:4], xlim = c(0, 10))
track <- ccTrack(ylim = c(0, 1))
cell <- ccCell(sector.index = "a") + ccArrow(x1 = 1, x2 = 9, y=0.5, width=0.5)
track <- track + cell
cc + track
}
