% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnn.R
\name{cnn}
\alias{cnn}
\title{CNN}
\usage{
cnn(
  X,
  Y = NULL,
  architecture,
  loss = c("mse", "mae", "softmax", "cross-entropy", "gaussian", "binomial", "poisson"),
  optimizer = c("sgd", "adam", "adadelta", "adagrad", "rmsprop", "rprop"),
  lr = 0.01,
  alpha = 0.5,
  lambda = 0,
  validation = 0,
  batchsize = 32L,
  burnin = 10,
  shuffle = TRUE,
  epochs = 100,
  early_stopping = NULL,
  lr_scheduler = NULL,
  custom_parameters = NULL,
  device = c("cpu", "cuda", "mps"),
  plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{X}{predictor: array with dimension 3, 4 or 5 for 1D-, 2D- or 3D-convolutions, respectively. The first dimension are the samples, the second dimension the channels and the third - fifth dimension are the input dimensions}

\item{Y}{response: vector, factor, numerical matrix or logical matrix}

\item{architecture}{'citoarchitecture' object created by \code{\link{create_architecture}}}

\item{loss}{loss after which network should be optimized. Can also be distribution from the stats package or own function, see details}

\item{optimizer}{which optimizer used for training the network, for more adjustments to optimizer see \code{\link{config_optimizer}}}

\item{lr}{learning rate given to optimizer}

\item{alpha}{add L1/L2 regularization to training  \eqn{(1 - \alpha) * |weights| + \alpha ||weights||^2} will get added for each layer. Must be between 0 and 1}

\item{lambda}{strength of regularization: lambda penalty, \eqn{\lambda * (L1 + L2)} (see alpha)}

\item{validation}{percentage of data set that should be taken as validation set (chosen randomly)}

\item{batchsize}{number of samples that are used to calculate one learning rate step}

\item{burnin}{training is aborted if the trainings loss is not below the baseline loss after burnin epochs}

\item{shuffle}{if TRUE, data in each batch gets reshuffled every epoch}

\item{epochs}{epochs the training goes on for}

\item{early_stopping}{if set to integer, training will stop if loss has gotten higher for defined number of epochs in a row, will use validation loss if available.}

\item{lr_scheduler}{learning rate scheduler created with \code{\link{config_lr_scheduler}}}

\item{custom_parameters}{List of parameters/variables to be optimized. Can be used in a custom loss function. See Vignette for example.}

\item{device}{device on which network should be trained on.}

\item{plot}{plot training loss}

\item{verbose}{print training and validation loss of epochs}
}
\value{
an S3 object of class \code{"citocnn"} is returned. It is a list containing everything there is to know about the model and its training process.
The list consists of the following attributes:
\item{net}{An object of class "nn_sequential" "nn_module", originates from the torch package and represents the core object of this workflow.}
\item{call}{The original function call}
\item{loss}{A list which contains relevant information for the target variable and the used loss function}
\item{data}{Contains data used for training the model}
\item{weights}{List of weights for each training epoch}
\item{use_model_epoch}{Integer, which defines which model from which training epoch should be used for prediction.}
\item{loaded_model_epoch}{Integer, shows which model from which epoch is loaded currently into model$net.}
\item{model_properties}{A list of properties of the neural network, contains number of input nodes, number of output nodes, size of hidden layers, activation functions, whether bias is included and if dropout layers are included.}
\item{training_properties}{A list of all training parameters that were used the last time the model was trained. It consists of learning rate, information about an learning rate scheduler, information about the optimizer, number of epochs, whether early stopping was used, if plot was active, lambda and alpha for L1/L2 regularization, batchsize, shuffle, was the data set split into validation and training, which formula was used for training and at which epoch did the training stop.}
\item{losses}{A data.frame containing training and validation losses of each epoch}
}
\description{
fits a custom convolutional neural network.
}
\section{Convolutional neural networks:}{
Convolutional Neural Networks (CNNs) are a specialized type of neural network designed for processing structured grid data, such as images.
The characterizing parts of the architecture are convolutional layers, pooling layers and fully-connected (linear) layers:
\itemize{
\item Convolutional layers are the core building blocks of CNNs. They consist of filters (also called kernels), which are small, learnable matrices. These filters slide over the input data to perform element-wise multiplication, producing feature maps that capture local patterns and features. Multiple filters are used to detect different features in parallel. They help the network learn hierarchical representations of the input data by capturing low-level features (edges, textures) and gradually combining them (in subsequent convolutional layers) to form higher-level features.
\item Pooling layers are used to downsample the spatial dimensions of the feature maps while retaining important information. Max pooling is a common pooling operation, where the maximum value in a local region of the input is retained, reducing the size of the feature maps.
\item Fully-connected (linear) layers connect every neuron in one layer to every neuron in the next layer. These layers are found at the end of the network and are responsible for combining high-level features to make final predictions.
}
}

\section{Loss functions / Likelihoods}{
We support loss functions and likelihoods for different tasks:\tabular{lll}{
   Name \tab Explanation \tab Example / Task \cr
   mse \tab mean squared error \tab Regression, predicting continuous values \cr
   mae \tab mean absolute error \tab Regression, predicting continuous values \cr
   softmax \tab categorical cross entropy \tab Multi-class, species classification \cr
   cross-entropy \tab categorical cross entropy \tab Multi-class, species classification \cr
   gaussian \tab Normal likelihood \tab Regression, residual error is also estimated (similar to \code{stats::lm()}) \cr
   binomial \tab Binomial likelihood \tab Classification/Logistic regression, mortality \cr
   Poisson \tab Poisson likelihood \tab Regression, count data, e.g. species abundances \cr
}
}

\section{Training and convergence of neural networks}{
Ensuring convergence can be tricky when training neural networks. Their training is sensitive to a combination of the learning rate (how much the weights are updated in each optimization step), the batch size (a random subset of the data is used in each optimization step), and the number of epochs (number of optimization steps). Typically, the learning rate should be decreased with the size of the neural networks (amount of learnable parameters). We provide a baseline loss (intercept only model) that can give hints about an appropriate learning rate:

\figure{learningrates.jpg}{Learning rates}

If the training loss of the model doesn't fall below the baseline loss, the learning rate is either too high or too low. If this happens, try higher and lower learning rates.

A common strategy is to try (manually) a few different learning rates to see if the learning rate is on the right scale.

See the troubleshooting vignette (\code{vignette("B-Training_neural_networks")}) for more help on training and debugging neural networks.
}

\section{Finding the right architecture}{
As with the learning rate, there is no definitive guide to choosing the right architecture for the right task. However, there are some general rules/recommendations: In general, wider, and deeper neural networks can improve generalization - but this is a double-edged sword because it also increases the risk of overfitting. So, if you increase the width and depth of the network, you should also add regularization (e.g., by increasing the lambda parameter, which corresponds to the regularization strength). Furthermore, in \href{https://arxiv.org/abs/2306.10551}{Pichler & Hartig, 2023}, we investigated the effects of the hyperparameters on the prediction performance as a function of the data size. For example, we found that the \code{selu} activation function outperforms \code{relu} for small data sizes (<100 observations).

We recommend starting with moderate sizes (like the defaults), and if the model doesn't generalize/converge, try larger networks along with a regularization that helps minimize the risk of overfitting (see \code{vignette("B-Training_neural_networks")} ).
}

\section{Overfitting}{
Overfitting means that the model fits the training data well, but generalizes poorly to new observations. We can use the validation argument to detect overfitting. If the validation loss starts to increase again at a certain point, it often means that the models are starting to overfit your training data:

\figure{overfitting.jpg}{Overfitting}

\strong{Solutions}:

\itemize{
\item Re-train with epochs = point where model started to overfit
\item Early stopping, stop training when model starts to overfit, can be specified using the \verb{early_stopping=…} argument
\item Use regularization (dropout or elastic-net, see next section)
}
}

\section{Regularization}{
Elastic Net regularization combines the strengths of L1 (Lasso) and L2 (Ridge) regularization. It introduces a penalty term that encourages sparse weight values while maintaining overall weight shrinkage. By controlling the sparsity of the learned model, Elastic Net regularization helps avoid overfitting while allowing for meaningful feature selection. We advise using elastic net (e.g. lambda = 0.001 and alpha = 0.2).

Dropout regularization helps prevent overfitting by randomly disabling a portion of neurons during training. This technique encourages the network to learn more robust and generalized representations, as it prevents individual neurons from relying too heavily on specific input patterns. Dropout has been widely adopted as a simple yet effective regularization method in deep learning.
In the case of 2D and 3D inputs whole feature maps are disabled. Since the torch package doesn't currently support feature map-wise dropout for 1D inputs, instead random neurons in the feature maps are disabled similar to dropout in linear layers.

By utilizing these regularization methods in your neural network training with the cito package, you can improve generalization performance and enhance the network's ability to handle unseen data. These techniques act as valuable tools in mitigating overfitting and promoting more robust and reliable model performance.
}

\section{Custom Optimizer and Learning Rate Schedulers}{
When training a network, you have the flexibility to customize the optimizer settings and learning rate scheduler to optimize the learning process. In the cito package, you can initialize these configurations using the \code{\link{config_lr_scheduler}} and \code{\link{config_optimizer}} functions.

\code{\link{config_lr_scheduler}} allows you to define a specific learning rate scheduler that controls how the learning rate changes over time during training. This is beneficial in scenarios where you want to adaptively adjust the learning rate to improve convergence or avoid getting stuck in local optima.

Similarly, the \code{\link{config_optimizer}} function enables you to specify the optimizer for your network. Different optimizers, such as stochastic gradient descent (SGD), Adam, or RMSprop, offer various strategies for updating the network's weights and biases during training. Choosing the right optimizer can significantly impact the training process and the final performance of your neural network.
}

\section{Training on graphic cards}{
If you have an NVIDIA CUDA-enabled device and have installed the CUDA toolkit version 11.3 and cuDNN 8.4, you can take advantage of GPU acceleration for training your neural networks. It is crucial to have these specific versions installed, as other versions may not be compatible.
For detailed installation instructions and more information on utilizing GPUs for training, please refer to the \href{https://torch.mlverse.org/docs/articles/installation.html}{mlverse: 'torch' documentation}.

Note: GPU training is optional, and the package can still be used for training on CPU even without CUDA and cuDNN installations.
}

\seealso{
\code{\link{predict.citocnn}}, \code{\link{plot.citocnn}},  \code{\link{coef.citocnn}}, \code{\link{print.citocnn}}, \code{\link{summary.citocnn}}, \code{\link{continue_training}}, \code{\link{analyze_training}}
}
\author{
Armin Schenk, Maximilian Pichler
}
