% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnn.R
\name{predict.citodnn}
\alias{predict.citodnn}
\alias{predict.citodnnBootstrap}
\title{Predict from a fitted dnn model}
\usage{
\method{predict}{citodnn}(
  object,
  newdata = NULL,
  type = c("link", "response", "class"),
  device = c("cpu", "cuda", "mps"),
  reduce = c("mean", "median", "none"),
  ...
)

\method{predict}{citodnnBootstrap}(
  object,
  newdata = NULL,
  type = c("link", "response", "class"),
  device = c("cpu", "cuda", "mps"),
  reduce = c("mean", "median", "none"),
  ...
)
}
\arguments{
\item{object}{a model created by \code{\link{dnn}}}

\item{newdata}{new data for predictions}

\item{type}{type of predictions. The default is on the scale of the linear predictor, "response" is on the scale of the response, and "class" means that class predictions are returned (if it is a classification task)}

\item{device}{device on which network should be trained on.}

\item{reduce}{predictions from bootstrapped model are by default reduced (mean, optional median or none)}

\item{...}{additional arguments}
}
\value{
prediction matrix
}
\description{
Predict from a fitted dnn model
}
\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

set.seed(222)
validation_set<- sample(c(1:nrow(datasets::iris)),25)

# Build and train  Network
nn.fit<- dnn(Sepal.Length~., data = datasets::iris[-validation_set,])

# Use model on validation set
predictions <- predict(nn.fit, iris[validation_set,])
# Scatterplot
plot(iris[validation_set,]$Sepal.Length,predictions)
# MAE
mean(abs(predictions-iris[validation_set,]$Sepal.Length))
}
}
}
