% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cistandard2.R
\name{cistandard2}
\alias{cistandard2}
\title{Compute the usual confidence interval}
\usage{
cistandard2(X, a, y, alpha)
}
\arguments{
\item{X}{A known \eqn{n} by \eqn{p} matrix}

\item{a}{A \eqn{p}-vector used to specify the parameter of interest}

\item{y}{The \eqn{n}-vector of observed responses}

\item{alpha}{1 - \code{alpha} is the coverage probability of the
confidence interval}
}
\value{
The usual 1 - \code{alpha} confidence interval.
}
\description{
Compute the usual 1 - \code{alpha} confidence interval
}
\details{
Suppose that \deqn{Y = X \beta + \epsilon} is a random \eqn{n}-vector
 of responses, \eqn{X} is a known \eqn{n} by \eqn{p} matrix with linearly
 independent columns, \eqn{\beta} is an unknown parameter \eqn{p}-vector and
 \eqn{\epsilon} is the random error with components that
  are independent and identically normally distributed with zero mean and
  unknown variance. The parameter of interest is \eqn{\theta = } \code{a}'
  \eqn{\beta}, where \code{a} is a specified \eqn{p}-vector.
  Then \code{cistandard2}
 computes the usual 1 - \code{alpha} confidence interval for \eqn{\theta},
 for given \eqn{n}-vector of observed responses \code{y}.


 In the examples, we continue with the same 2 x 2 factorial example described
 in the documentation for \code{\link{find_rho}}, for the vector of observed
 responses \eqn{y} = (-1.3, 0.8, 2.6, 5.8, 0.3, 1.3, 4.3, 5.0, -0.4, 1.0,
 5.2, 6.2).

  The design matrix \eqn{X} and the vector \code{a} (denoted in
  R by a.vec) are entered into R using the commands
  in the following example.
}
\examples{
col1 <- rep(1,4)
col2 <- c(-1, 1, -1, 1)
col3 <- c(-1, -1, 1, 1)
col4 <- c(1, -1, -1, 1)
X.single.rep <- cbind(col1, col2, col3, col4)
X <- rbind(X.single.rep, X.single.rep, X.single.rep)
a.vec <- c(0, 2, 0, -2)
y <- c(-1.3, 0.8, 2.6, 5.8, 0.3, 1.3, 4.3, 5.0, -0.4, 1.0, 5.2, 6.2)

# Calculate the usual 95\% confidence interval
res <- cistandard2(X, a=a.vec, y, alpha = 0.05)
res

# The usual 1 - alpha confidence interval for theta is (-0.08185, 3.08185)

}
\references{
Kabaila, P. and Giri, K. (2009) Confidence intervals in regression
 utilizing prior information.  Journal of Statistical Planning and Inference,
 139, 3419 - 3429.
}
\seealso{
\code{\link{find_rho}}
}
