% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_list_identity_resolution}
\alias{enhancements_list_identity_resolution}
\title{List Identity Resolution Enhancements}
\usage{
enhancements_list_identity_resolution(
  archived = NULL,
  status = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{archived}{string optional. The archival status of the requested item(s).}

\item{status}{string optional. If specified, returns items with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'failed', 'succeeded', 'idle', 'scheduled'.}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 100.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, created_at, last_run_updated_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for the enhancement.}
\item{name}{string, The name of the enhancement job.}
\item{type}{string, The type of the enhancement (e.g CASS-NCOA)}
\item{createdAt}{string, The time this enhancement was created.}
\item{updatedAt}{string, The time the enhancement was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the enhancement's last run}
\item{archived}{string, The archival status of the requested item(s).}
\item{sources}{array, An array containing the following fields: 
\itemize{
\item name string, A user-specified name for the source.
}}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
\item sampleRecordsQuery string, A SQL query to produce a sample of records to inspect.
\item expandClusterQuery string, A customizable query to view PII associated with resolved ids.
\item runMetrics list . A list containing the following elements: 
\itemize{
\item numRecords integer, The number of input records for this run.
\item uniqueIds integer, The number of distinct unique IDs in the input records for this run.
\item uniqueDeduplicatedIds integer, The number of resolved IDs associated with more than one unique ID in the input.
\item maxClusterSize integer, The number of records in the largest cluster of resolved IDs.
\item avgClusterSize number, The average number of records with the same resolved ID.
\item clusterSizeFrequencies object, A mapping from numbers of records with the same resolved ID (i.e., sizes of clusters) to numbers of such clusters. For example, if there were 10 clusters with 2 records each, 2 would be a key in the mapping, and 10 would be its value.
}
}}
}
\description{
List Identity Resolution Enhancements
}
