% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_post_civis_data_match_clone}
\alias{enhancements_post_civis_data_match_clone}
\title{Clone this Civis Data Match Enhancement}
\usage{
enhancements_post_civis_data_match_clone(
  id,
  clone_schedule = NULL,
  clone_triggers = NULL,
  clone_notifications = NULL
)
}
\arguments{
\item{id}{integer required. The ID for the enhancement.}

\item{clone_schedule}{boolean optional. If true, also copy the schedule to the new enhancement.}

\item{clone_triggers}{boolean optional. If true, also copy the triggers to the new enhancement.}

\item{clone_notifications}{boolean optional. If true, also copy the notifications to the new enhancement.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the enhancement.}
\item{name}{string, The name of the enhancement job.}
\item{type}{string, The type of the enhancement (e.g CASS-NCOA)}
\item{createdAt}{string, The time this enhancement was created.}
\item{updatedAt}{string, The time the enhancement was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the enhancement's last run}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on. Defaults to user's preferences.
\item failureOn boolean, If failure email notifications are on. Defaults to user's preferences.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{inputFieldMapping}{list, The field (i.e., column) mapping for the input table. See https://api.civisanalytics.com/enhancements/field-mapping for a list of valid field types and descriptions. Each field type should be mapped to a string specifying a column name in the input table. For field types that support multiple values (e.g., the "phone" field), a list of column names can be provided (e.g., \{"phone": ["home_phone", "mobile_phone"], ...\}).}
\item{inputTable}{list, A list containing the following elements: 
\itemize{
\item databaseName string, The Redshift database name for the table.
\item schema string, The schema name for the table.
\item table string, The table name.
}}
\item{matchTargetId}{integer, The ID of the Civis Data match target. See /match_targets for IDs.}
\item{outputTable}{list, A list containing the following elements: 
\itemize{
\item databaseName string, The Redshift database name for the table.
\item schema string, The schema name for the table.
\item table string, The table name.
}}
\item{maxMatches}{integer, The maximum number of matches per record in the input table to return. Must be between 0 and 10. 0 returns all matches.}
\item{threshold}{number, The score threshold (between 0 and 1). Matches below this threshold will not be returned. The default value is 0.5.}
\item{archived}{boolean, Whether the Civis Data Match Job has been archived.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{parentId}{integer, Parent ID that triggers this enhancement.}
}
\description{
Clone this Civis Data Match Enhancement
}
