% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{reports_put_archive}
\alias{reports_put_archive}
\title{Update the archive status of this object}
\usage{
reports_put_archive(id, status)
}
\arguments{
\item{id}{integer required. The ID of the object.}

\item{status}{boolean required. The desired archived status of the object.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this report.}
\item{name}{string, The name of the report.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, The creation time for this report.}
\item{updatedAt}{string, The last updated at time for this report.}
\item{type}{string, The type of the report. One of: ReportTypes::HTML, ReportTypes::Tableau, ReportTypes::ShinyApp, ReportTypes::SQL}
\item{description}{string, The user-defined description of the report.}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{archived}{string, The archival status of the requested item(s).}
\item{projects}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID for the project.
\item name string, The name of the project.
}}
\item{state}{string, The status of the report's last run.}
\item{finishedAt}{string, The time that the report's last run finished.}
\item{vizUpdatedAt}{string, The time that the report's visualization was last updated.}
\item{script}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID for the script.
\item name string, The name of the script.
\item sql string, The raw SQL query for the script, if applicable.
}}
\item{jobPath}{string, The link to details of the job that backs this report.}
\item{tableauId}{integer, }
\item{templateId}{integer, The ID of the template used for this report.}
\item{authThumbnailUrl}{string, URL for a thumbnail of the report.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{hidden}{boolean, The hidden status of the item.}
\item{authDataUrl}{string, DEPRECATED: For legacy reports}
\item{authCodeUrl}{string, Link to code to render in the report.}
\item{config}{string, Any configuration metadata for this report.}
\item{validOutputFile}{boolean, Whether the job (a script or a query) that backs the report currently has a valid output file.}
\item{provideAPIKey}{boolean, Whether the report requests an API Key from the report viewer.}
\item{apiKey}{string, A Civis API key that can be used by this report.}
\item{apiKeyId}{integer, The ID of the API key. Can be used for auditing API use by this report.}
\item{appState}{list, Any application state blob for this report.}
\item{useViewersTableauUsername}{boolean, Apply user level filtering on Tableau reports.}
}
\description{
Update the archive status of this object
}
