% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{table_tags_list}
\alias{table_tags_list}
\title{List Table Tags}
\usage{
table_tags_list(
  name = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{name}{string optional. Name of the tag. If it is provided, the results will be filtered by name}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to name. Must be one of: name, user, table_count.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, Table Tag ID}
\item{name}{string, Table Tag Name}
\item{tableCount}{integer, The total number of tables associated with the tag.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
}
\description{
List Table Tags
}
