% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_delete.R
\name{resource_delete}
\alias{resource_delete}
\title{Delete a resource.}
\usage{
resource_delete(id, url = get_default_url(), key = get_default_key(), ...)
}
\arguments{
\item{id}{(character) Resource identifier.}

\item{url}{Base url to use. Default: https://data.ontario.ca
See also \code{\link[=ckanr_setup]{ckanr_setup()}} and \code{\link[=get_default_url]{get_default_url()}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{...}{Curl args passed on to \link[crul:verb-POST]{crul::verb-POST} (optional)}
}
\description{
Delete a resource.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = Sys.getenv("CKAN_DEMO_KEY"))

# create a package
(res <- package_create("yellow9"))

# then create a resource
file <- system.file("examples", "actinidiaceae.csv", package = "ckanr")
(xx <- resource_create(res,
                       description = "my resource",
                       name = "bears",
                       upload = file,
                       rcurl = "http://google.com"
))

# delete the resource
resource_delete(xx)
}
}
