% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{station_world}
\alias{station_world}
\title{Climate stations of the world}
\format{
A data frame with 3444 rows and 9 variable:
\describe{
\item{no           }{Station no}
\item{station      }{Station name. To avoid duplication, including country name after station name. Can split by "_". Escaped by stringi::stri_escape_unicode().}
\item{continent    }{Continent. Escaped by stringi::stri_escape_unicode().}
\item{country      }{Country name. Escaped by stringi::stri_escape_unicode().}
\item{altitude     }{Altitude (m)}
\item{latitude     }{Latitude (degree)}
\item{NS           }{North or South.}
\item{longitude    }{Longitude (degree)}
\item{WE           }{West or East}
}
}
\usage{
station_world
}
\description{
Climate stations of the world
}
\examples{
library(magrittr)
library(stringi)
library(dplyr)
data(station_world)
station_world \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode)
}
\keyword{datasets}
