% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_overview.R
\name{data_overview}
\alias{data_overview}
\title{Data Overview and Quality Check}
\usage{
data_overview(
  df,
  outlier_method = "iqr",
  outlier_threshold = NULL,
  verbose = TRUE
)
}
\arguments{
\item{df}{A data.frame to be analyzed}

\item{outlier_method}{Method for detecting outliers, one of "iqr" (default), "zscore", or "mad"}

\item{outlier_threshold}{Threshold value for detecting outliers. If NULL (default),
uses method-specific defaults:
\itemize{
\item For MAD method: 1.4826 * 3 (approximately 3 standard deviations)
\item For IQR method: 1.5 (Tukey's rule)
\item For Z-score method: 3 (3 standard deviations)
}}

\item{verbose}{If TRUE (default), prints result messages}
}
\value{
A list containing:
\itemize{
\item variable_types: Classification of variables by type
\item summary_stats: Summary statistics for each variable
\item quality_issues: Identified data quality problems
\item recommendations: Suggestions for data cleaning
}
}
\description{
This function provides a comprehensive overview of a data.frame, including variable types,
summary statistics, and potential data quality issues. It serves as a starting point for
data cleaning by identifying problems that need attention.
}
\examples{
# Basic usage
data(mtcars)
overview <- data_overview(mtcars)
print(overview$variable_types)
print(overview$quality_issues)

}
