% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_outlier.R
\name{detect_outliers}
\alias{detect_outliers}
\title{Detect outliers in a numeric vector.}
\usage{
detect_outliers(x, method = "iqr", threshold = NULL)
}
\arguments{
\item{x}{A numeric vector.}

\item{method}{The method to use for outlier detection. One of "mad", "iqr", or "zscore".}

\item{threshold}{The threshold value for detecting outliers. Defaults depend on the method.}
}
\value{
A list containing:
\itemize{
\item outlier_mask: Logical vector indicating outliers, \code{NA} for missing values
\item outlier_count: Number of outliers detected
\item outlier_pct: Percentage of outliers in the data
\item summary: Summary statistics including:
\itemize{
\item Before removing outliers: max, min, variance
\item After removing outliers: max, min, variance
\item Method-specific details
}
}
}
\description{
Detect outliers in a numeric vector using various methods.
}
\details{
This function provides a unified interface for detecting outliers using different methods.
\itemize{
\item "mad": Median absolute deviation method
\item "iqr": Interquartile range method
\item "zscore": Z-score method
}
}
\examples{
x <- c(1, 2, 3, 4, 5, 100)
detect_outliers(x, method = "iqr")
}
\seealso{
\code{\link{mad_outlier}}, \code{\link{iqr_outlier}}, \code{\link{zscore_outlier}}
}
