% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_outlier.R
\name{mad_outlier}
\alias{mad_outlier}
\alias{iqr_outlier}
\alias{zscore_outlier}
\title{Mark possible outliers using different methods.}
\usage{
mad_outlier(x, threshold = 1.4826 * 3)

iqr_outlier(x, threshold = 1.5)

zscore_outlier(x, threshold = 3)
}
\arguments{
\item{x}{A numeric vector.}

\item{threshold}{The threshold value for detecting outliers. Defaults depend on the method:
\itemize{
\item For MAD method: 1.4826 * 3 (approximately 3 standard deviations)
\item For IQR method: 1.5 (Tukey's rule)
\item For Z-score method: 3 (3 standard deviations)
}}
}
\value{
A logical vector indicating which values are outliers.
}
\description{
Mark possible outliers in a numeric vector using various methods.
These functions return a logical vector indicating which values are outliers.
}
\details{
\itemize{
\item \strong{MAD method}: Uses median absolute deviation to identify outliers.
Values with absolute deviation from the median greater than the threshold are considered outliers.
\item \strong{IQR method}: Uses interquartile range to identify outliers.
Values below Q1 - threshold * IQR or above Q3 + threshold * IQR are considered outliers.
\item \strong{Z-score method}: Uses standardized Z-scores to identify outliers.
Values with an absolute Z-score greater than the threshold are considered outliers.
}
}
\examples{
x <- c(1, 2, 3, 4, 5, 100, NA)
mad_outlier(x)
iqr_outlier(x, threshold = 2.0)
zscore_outlier(x, threshold = 2.5)
}
