\name{aua_symptom_index}
\alias{aua_symptom_index}
\title{
American Urological Association Symptom Index (AUA-SI)
}
\description{
Calculates the AUA Symptom Index (also known as the International Prostate Symptom Score, IPSS) for Benign Prostatic Hyperplasia (BPH). The index consists of 7 questions regarding urinary symptoms, each scored from 0 to 5. An optional 8th question assesses Quality of Life (QoL) regarding urinary symptoms.
}
\usage{
aua_symptom_index(incomplete_emptying, frequency, intermittency, urgency,
                  weak_stream, straining, nocturia, quality_of_life = NULL)
}
\arguments{
  \item{incomplete_emptying}{
Numeric (0-5). Sensation of not emptying bladder completely after finishing.
}
  \item{frequency}{
Numeric (0-5). Frequency of urination (less than 2 hours after finishing).
}
  \item{intermittency}{
Numeric (0-5). Stopping and starting several times when urinating.
}
  \item{urgency}{
Numeric (0-5). Difficulty postponing urination.
}
  \item{weak_stream}{
Numeric (0-5). Weak urinary stream.
}
  \item{straining}{
Numeric (0-5). Need to push or strain to begin urination.
}
  \item{nocturia}{
Numeric (0-5). Number of times getting up to urinate from the time going to bed until getting up in the morning.
}
  \item{quality_of_life}{
Numeric (0-6) (Optional). "If you were to spend the rest of your life with your urinary condition just the way it is now, how would you feel about that?"
0=Delighted, 1=Pleased, 2=Mostly Satisfied, 3=Mixed, 4=Mostly Dissatisfied, 5=Unhappy, 6=Terrible.
}
}
\details{
\strong{Scoring Key (Questions 1-6):}
0 = Not at all
1 = Less than 1 time in 5
2 = Less than half the time
3 = About half the time
4 = More than half the time
5 = Almost always
}
\value{
A list containing:
\item{AUA_Symptom_Score}{Sum of the 7 symptom scores (Range 0-35).}
\item{Severity_Category}{"Mild" (0-7), "Moderate" (8-19), or "Severe" (20-35).}
\item{Quality_of_Life_Description}{Text description corresponding to the QoL score.}
}
\references{
Barry MJ, Fowler FJ Jr, O'Leary MP, et al. The American Urological Association symptom index for benign prostatic hyperplasia. The Measurement Committee of the American Urological Association. J Urol. 1992;148(5):1549-1557. doi:10.1016/s0022-5347(17)36966-5
}
\examples{

# Example 1: Moderate Symptoms
# Scores: 2, 2, 3, 1, 3, 1, 2 = 14
aua_symptom_index(2, 2, 3, 1, 3, 1, 2, quality_of_life = 3)

# Example 2: Mild Symptoms
# All 1s = 7
aua_symptom_index(1, 1, 1, 1, 1, 1, 1)
}
