\name{blast_lung_injury_severity}
\alias{blast_lung_injury_severity}
\title{
Blast Lung Injury Severity Score (BLISS)
}
\description{
Calculates the Blast Lung Injury Severity Score to stratify patients with primary blast lung injury (PBLI). The score guides ventilator management strategies based on the severity of lung injury, assessing oxygenation (PaO2/FiO2), chest x-ray findings, and the presence of a bronchopleural fistula.
}
\usage{
blast_lung_injury_severity(pao2_fio2_ratio, chest_xray_findings,
                           bronchopleural_fistula)
}
\arguments{
  \item{pao2_fio2_ratio}{
Numeric. The ratio of arterial partial pressure of oxygen to fraction of inspired oxygen (PaO2/FiO2).
> 200: 0 points.
60 - 200: 2 points.
< 60: 4 points.
}
  \item{chest_xray_findings}{
Numeric (0-2). Findings on Chest X-ray.
0: Localized lung infiltrates (1 point).
1: Bilateral or unilateral lung infiltrates (not massive bilateral) (2 points).
2: Massive bilateral lung infiltrates (3 points).
}
  \item{bronchopleural_fistula}{
Numeric (0 or 1). Presence of a Bronchopleural Fistula. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{BLISS_Score}{The calculated total score.}
\item{Severity_Category}{Classification (Mild, Moderate, Severe).}
\item{Ventilator_Management}{Recommendations for mechanical ventilation settings (PEEP, modes) based on severity.}
}
\references{
Pizov R, Oppenheim-Eden A, Matot I, et al. Blast lung injury from explosion of a bomb in a civilian bus. Chest. 1999;115(1):165-172. doi:10.1378/chest.115.1.165
}
\examples{

# Example 1: Moderate Injury
# PF 150 (2 pts), Bilateral infiltrates (2 pts), No BPF (0 pts)
# Score = 4
blast_lung_injury_severity(150, 1, 0)

# Example 2: Severe Injury
# PF 50 (4 pts), Massive bilateral (3 pts), BPF present (1 pt)
# Score = 8
blast_lung_injury_severity(50, 2, 1)
}
