\name{brugada_criteria_vt}
\alias{brugada_criteria_vt}
\title{
Brugada Criteria for Ventricular Tachycardia
}
\description{
Implements the Brugada Algorithm to differentiate Ventricular Tachycardia (VT) from Supraventricular Tachycardia (SVT) with aberrancy in patients with wide complex tachycardia. The algorithm follows a four-step sequential evaluation. If any step is positive, the diagnosis is VT. If all steps are negative, the diagnosis defaults to SVT with aberrancy.
}
\usage{
brugada_criteria_vt(absent_rs_precordial, rs_interval_gt_100,
                    av_dissociation, morphology_criteria_vt)
}
\arguments{
  \item{absent_rs_precordial}{
Numeric (0 or 1). Step 1: Is there an absence of an RS complex in ALL precordial leads? (1 = Yes -> VT).
}
  \item{rs_interval_gt_100}{
Numeric (0 or 1). Step 2: Is the RS interval (onset of R to nadir of S) > 100 ms in ANY precordial lead? (1 = Yes -> VT).
}
  \item{av_dissociation}{
Numeric (0 or 1). Step 3: Is there AV dissociation? (1 = Yes -> VT).
}
  \item{morphology_criteria_vt}{
Numeric (0 or 1). Step 4: Are morphology criteria for VT present in leads V1-2 and V6? (1 = Yes -> VT).
}
}
\value{
A list containing:
\item{Diagnosis}{"Ventricular Tachycardia (VT)" or "SVT with Aberrancy".}
\item{Step_Positive}{The step number (1-4) that confirmed VT, or 0 if SVT.}
}
\references{
Brugada P, Brugada J, Mont L, Smeets J, Andries EW. A new approach to the differential diagnosis of a regular tachycardia with a wide QRS complex. Circulation. 1991;83(5):1649-1659. doi:10.1161/01.cir.83.5.1649
}
\examples{

# Example 1: VT diagnosed at Step 2
# RS complex present (0), but RS interval > 100ms (1)
brugada_criteria_vt(0, 1, 0, 0)

# Example 2: SVT with Aberrancy
# All criteria negative
brugada_criteria_vt(0, 0, 0, 0)
}
