\name{cahp_cardiac_arrest_score}
\alias{cahp_cardiac_arrest_score}
\title{
CAHP (Cardiac Arrest Hospital Prognosis) Score
}
\description{
Calculates the CAHP score to predict neurological outcome (CPC 3-5) in patients admitted to the ICU after out-of-hospital cardiac arrest (OHCA). The score is typically used for patients treated with targeted temperature management (TTM). It stratifies patients into Low, Intermediate, and High risk for poor neurological outcome.
}
\usage{
cahp_cardiac_arrest_score(age, location_home, initial_rhythm_shockable,
                          no_flow_minutes, low_flow_minutes,
                          epinephrine_dose_mg, arterial_ph)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{location_home}{
Numeric (0 or 1). Did the arrest occur at home? (1 = Yes, 0 = Public).
}
  \item{initial_rhythm_shockable}{
Numeric (0 or 1). Was the initial rhythm shockable (VF/VT)? (1 = Yes, 0 = No/PEA/Asystole).
}
  \item{no_flow_minutes}{
Numeric. Duration from collapse to start of CPR (No-flow interval). If unknown, >3 mins is typically assumed (High risk).
}
  \item{low_flow_minutes}{
Numeric. Duration from start of CPR to Return of Spontaneous Circulation (ROSC) (Low-flow interval).
}
  \item{epinephrine_dose_mg}{
Numeric. Total dose of epinephrine administered during resuscitation in mg.
}
  \item{arterial_ph}{
Numeric. Arterial pH measured on admission.
}
}
\value{
A list containing:
\item{CAHP_Score}{The calculated prognostic score (Range 0- ~285).}
\item{Risk_Group}{Classification (Low <150, Intermediate 150-200, High >200).}
\item{Prob_Poor_Neuro_Outcome}{Estimated percentage risk of poor neurological outcome (CPC 3-5) at discharge/6 months.}
}
\references{
Maupain C, Bougouin W, Lamhaut L, et al. The CAHP (Cardiac Arrest Hospital Prognosis) score: a tool for risk stratification after out-of-hospital cardiac arrest. Eur Heart J. 2016;37(42):3222-3231. doi:10.1093/eurheartj/ehv556
}
\examples{

# Example 1: Good Prognosis
# 40yo (0), Public arrest (0), Shockable (0), No flow 0 (0), Low flow 10 (0), 0 Epi (0), pH 7.4 (0)
# Score = 0
cahp_cardiac_arrest_score(40, 0, 1, 0, 10, 0, 7.4)

# Example 2: Poor Prognosis
# 80yo (53), Home (16), Asystole (27), No flow 5 (29), Low flow 40 (32), 3mg Epi (32), pH 7.1 (25)
# Score = 53 + 16 + 27 + 29 + 32 + 32 + 25 = 214
cahp_cardiac_arrest_score(80, 1, 0, 5, 40, 3, 7.1)
}
