\name{calculate_feurea}
\alias{calculate_feurea}
\title{
Fractional Excretion of Urea (FEUrea)
}
\description{
Calculates the Fractional Excretion of Urea (FEUrea), a diagnostic index used to differentiate between prerenal azotemia and intrinsic acute kidney injury (specifically Acute Tubular Necrosis, ATN). FEUrea is particularly useful when the patient is on diuretics, which can alter sodium excretion and render the FENa test unreliable.
}
\usage{
calculate_feurea(serum_urea, serum_creatinine, urine_urea, urine_creatinine,
                 urea_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{serum_urea}{
Numeric. Serum Urea level (or BUN).
}
  \item{serum_creatinine}{
Numeric. Serum Creatinine level.
}
  \item{urine_urea}{
Numeric. Urine Urea level (or Urine Urea Nitrogen).
}
  \item{urine_creatinine}{
Numeric. Urine Creatinine level.
}
  \item{urea_units}{
String. Units for the urea/BUN input. Options: "mg/dL" (Standard Urea), "BUN_mg_dL" (Blood Urea Nitrogen), or "mmol/L" (SI Units). Note: Ensure consistent units (mass vs molar) or rely on the function's internal standardization to mg/dL. The calculation is a ratio, so as long as serum and urine urea use the same units, and serum and urine creatinine use the same units, the result is valid. The function standardizes to mg/dL for consistency in handling mixed inputs.
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "micromol/L" (or "umol/L").
}
}
\value{
A list containing:
\item{FEUrea_Percent}{The calculated FEUrea value as a percentage.}
\item{Etiology}{Interpretation of the result: Prerenal (<35\%), Intrinsic (>50\%), or Indeterminate.}
}
\references{
Carvounis CP, Nisar S, Guro-Razuman S. Significance of the fractional excretion of urea in the differential diagnosis of acute renal failure. Kidney Int. 2002;62(6):2223-2229. doi:10.1046/j.1523-1755.2002.00683.x
}
\examples{

# Example 1: Prerenal (on diuretics)
# Serum Urea 50 mg/dL, Serum Cr 1.5 mg/dL, Urine Urea 200 mg/dL, Urine Cr 100 mg/dL
# FEUrea = (200 * 1.5) / (50 * 100) * 100 = 6
calculate_feurea(50, 1.5, 200, 100)

# Example 2: Intrinsic (ATN)
# Serum Urea 40, Serum Cr 2.0, Urine Urea 100, Urine Cr 40
# FEUrea = (100 * 2.0) / (40 * 40) * 100 = 12.5
# (100*2)/(40*40) = 200/1600 = 0.125 * 100 = 12.5
# let's try values that give >50
# Intrinsic: U-Urea 300, U-Cr 30, S-Urea 60, S-Cr 2.0
# FEUrea = (300 * 2.0) / (60 * 30) * 100 = 600 / 1800 = 33
# Try U-Urea 600: (600*2)/(60*30) = 1200/1800 = 66
calculate_feurea(60, 2.0, 600, 30)
}
