\name{cambridge_diabetes_risk}
\alias{cambridge_diabetes_risk}
\title{
Cambridge Diabetes Risk Score
}
\description{
Calculates the Cambridge Diabetes Risk Score to estimate the probability of having undiagnosed Type 2 diabetes. This tool uses non-invasive data including age, sex, BMI, family history, smoking status, and medication history to stratify risk.
}
\usage{
cambridge_diabetes_risk(age, sex, bmi, family_history, smoking_status,
                        rx_steroids_htn)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
< 45: 0 points.
45-54: 6 points.
55-64: 11 points.
>= 65: 13 points.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds +1 point).
}
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2).
< 25: 0 points.
25-27.49: 4 points.
27.5-29.99: 9 points.
>= 30: 15 points.
}
  \item{family_history}{
Numeric (0 or 1). History of diabetes in a parent or sibling. (1 = Yes, +5 points).
}
  \item{smoking_status}{
String. Smoking history. Options:
"non": Never smoked (0 points).
"past": Ex-smoker (2 points).
"current": Current smoker (4 points).
}
  \item{rx_steroids_htn}{
Numeric (0 or 1). Current use of prescribed steroids or anti-hypertensive medication. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{Cambridge_Risk_Score}{The total calculated score.}
\item{Interpretation}{Risk assessment based on the score threshold (Score >= 14 indicates high risk).}
}
\references{
Griffin SJ, Little PS, Hales CN, Kinmonth AL, Wareham NJ. Diabetes risk score: towards earlier detection of type 2 diabetes in general practice. Diabetes Metab Res Rev. 2000;16(3):164-171.
}
\examples{

# Example 1: High Risk
# 60yo Male (+11+1), BMI 31 (+15), FamHx (+5), Ex-Smoker (+2), No Rx
# Score = 12 + 15 + 5 + 2 = 34
cambridge_diabetes_risk(60, "male", 31, 1, "past", 0)

# Example 2: Low Risk
# 40yo Female (0+0), BMI 24 (0), No FamHx, Non-Smoker, No Rx
# Score = 0
cambridge_diabetes_risk(40, "female", 24, 0, "non", 0)
}
