\name{canadian_tia_score}
\alias{canadian_tia_score}
\title{
Canadian Transient Ischemic Attack (TIA) Score
}
\description{
Calculates the Canadian TIA Score to stratify the risk of subsequent stroke within 7 days in patients presenting to the Emergency Department with a TIA. It incorporates history, clinical features, vital signs, and investigations (CT, laboratory) to categorize patients into Low, Medium, or High risk.
}
\usage{
canadian_tia_score(history_tia_stroke, history_afib, unilateral_weakness,
                   speech_disturbance, duration_ge_10min, dbp_ge_110,
                   platelets_ge_400, glucose_ge_15, ct_findings,
                   carotid_stenosis_ge_50)
}
\arguments{
  \item{history_tia_stroke}{
Numeric (0 or 1). History of previous TIA or Stroke. (1 = Yes, +1 point).
}
  \item{history_afib}{
Numeric (0 or 1). History of Atrial Fibrillation or new AFib on ECG. (1 = Yes, +2 points).
}
  \item{unilateral_weakness}{
Numeric (0 or 1). Unilateral weakness. (1 = Yes, +2 points).
}
  \item{speech_disturbance}{
Numeric (0 or 1). Speech disturbance (aphasia or dysarthria). (1 = Yes, +2 points).
}
  \item{duration_ge_10min}{
Numeric (0 or 1). Duration of symptoms >= 10 minutes. (1 = Yes, +2 points).
}
  \item{dbp_ge_110}{
Numeric (0 or 1). Diastolic Blood Pressure >= 110 mmHg at triage or initial assessment. (1 = Yes, +2 points).
}
  \item{platelets_ge_400}{
Numeric (0 or 1). Platelet count >= 400 x 10^9/L. (1 = Yes, +2 points).
}
  \item{glucose_ge_15}{
Numeric (0 or 1). Serum glucose >= 15 mmol/L (>= 270 mg/dL). (1 = Yes, +2 points).
}
  \item{ct_findings}{
Numeric (0, 1, or 2). Findings on initial CT Head.
0: Normal or non-specific.
1: Old infarction only (+1 point).
2: Acute infarction (with or without old infarction) (+2 points).
}
  \item{carotid_stenosis_ge_50}{
Numeric (0 or 1). Carotid stenosis >= 50\% on Doppler US or CTA. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{Canadian_TIA_Score}{The calculated score.}
\item{Risk_Category}{"Low Risk" (Score <= 3), "Medium Risk" (Score 4-8), or "High Risk" (Score > 8).}
\item{Subsequent_Stroke_Risk_7_Day}{Estimated probability of stroke within 7 days.}
}
\references{
Perry JJ, Sharma M, Sivilotti ML, et al. Prospective validation of the Canadian TIA Score and comparison with the ABCD2 and ABCD2-I scores. Stroke. 2014;45(6):1645-1652. doi:10.1161/STROKEAHA.114.004652
}
\examples{

# Example 1: High Risk
# Hx Stroke (+1), AFib (+2), Weakness (+2), Duration >10m (+2), CT Acute (+2)
# Score = 9
canadian_tia_score(1, 1, 1, 0, 1, 0, 0, 0, 2, 0)

# Example 2: Low Risk
# Speech dist (+2), Duration 5 min (0), Normal CT (0), No other factors
# Score = 2
canadian_tia_score(0, 0, 0, 1, 0, 0, 0, 0, 0, 0)
}
