\name{chip_head_injury_rule}
\alias{chip_head_injury_rule}
\title{
CHIP Prediction Rule for CT in Head Injury Patients
}
\description{
Applies the CHIP (CT in Head Injury Patients) Prediction Rule to determine the need for a CT scan in patients with minor head injury (GCS 13-15). The rule identifies patients at high risk for intracranial complications requiring neurosurgical intervention.
}
\usage{
chip_head_injury_rule(age, gcs, vomiting, amnesia, skull_fracture_signs,
                      neurological_deficit, seizure, coagulopathy,
                      dangerous_mechanism)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 60 years is a risk factor).
}
  \item{gcs}{
Numeric. Glasgow Coma Scale score. (< 15 is a risk factor).
}
  \item{vomiting}{
Numeric (0 or 1). Any episode of vomiting. (1 = Yes).
}
  \item{amnesia}{
Numeric (0 or 1). Post-traumatic amnesia (anterograde > 4 hours) or retrograde amnesia (> 30 minutes). (1 = Yes).
}
  \item{skull_fracture_signs}{
Numeric (0 or 1). Clinical signs of skull fracture (depressed, basal, or penetrating). (1 = Yes).
}
  \item{neurological_deficit}{
Numeric (0 or 1). Any focal neurological deficit. (1 = Yes).
}
  \item{seizure}{
Numeric (0 or 1). Post-traumatic seizure. (1 = Yes).
}
  \item{coagulopathy}{
Numeric (0 or 1). History of coagulopathy or use of anticoagulant medication (e.g., warfarin). (1 = Yes).
}
  \item{dangerous_mechanism}{
Numeric (0 or 1). High-energy mechanism of injury (e.g., Pedestrian/cyclist vs vehicle, ejection from vehicle, fall from elevation > 1m/5 stairs). (1 = Yes).
}
}
\value{
A list containing:
\item{Recommendation}{"CT Head Indicated" or "CT Head Not Indicated".}
\item{Risk_Factors_Present}{A list of the specific criteria met that triggered the indication for CT.}
}
\references{
Smits M, Dippel DW, Steyerberg EW, et al. Predicting intracranial traumatic findings on computed tomography in patients with minor head injury: the CHIP prediction rule. Ann Intern Med. 2007;146(6):397-405. doi:10.7326/0003-4819-146-6-200703200-00004
}
\examples{

# Example 1: High Risk (Age)
# 70yo, GCS 15, no other symptoms
chip_head_injury_rule(70, 15, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Low Risk
# 30yo, GCS 15, minor mechanism, no symptoms
chip_head_injury_rule(30, 15, 0, 0, 0, 0, 0, 0, 0)

# Example 3: High Risk (Vomiting)
# 25yo, GCS 15, Vomiting present
chip_head_injury_rule(25, 15, 1, 0, 0, 0, 0, 0, 0)
}
