\name{cp_sss_stroke_score}
\alias{cp_sss_stroke_score}
\title{
Cincinnati Prehospital Stroke Severity Scale (CP-SSS)
}
\description{
Calculates the CP-SSS score to identify patients with suspected acute ischemic stroke who are at high risk for Large Vessel Occlusion (LVO). This tool helps EMS providers triage patients to the appropriate facility (e.g., Comprehensive Stroke Center for thrombectomy).
}
\usage{
cp_sss_stroke_score(conjugate_gaze_deviation, severe_arm_weakness,
                    loc_questions_incorrect)
}
\arguments{
  \item{conjugate_gaze_deviation}{
Numeric (0 or 1). Presence of conjugate gaze deviation (eyes fixed to one side). (1 = Yes, +2 points).
}
  \item{severe_arm_weakness}{
Numeric (0 or 1). Presence of severe arm weakness (arm falls to bed before 10 seconds or cannot lift arm). (1 = Yes, +1 point).
}
  \item{loc_questions_incorrect}{
Numeric (0 or 1). Patient answers 1 or both Level of Consciousness questions incorrectly (Age and Month). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{CP_SSS_Score}{The calculated score (Range 0-4).}
\item{LVO_Likelihood}{"High Likelihood" if Score >= 2, otherwise "Low Likelihood".}
\item{Recommendation}{Triage guidance based on the score.}
}
\references{
Katz BS, McMullan JT, Sucharew H, Adeoye O, Broderick JP. Design and validation of a prehospital scale to predict severe stroke. Stroke. 2015;46(6):1508-1512. doi:10.1161/STROKEAHA.115.008804
}
\examples{

# Example 1: High Probability of LVO
# Gaze deviation (+2), Severe Arm Weakness (+1), LOC intact
# Score = 3
cp_sss_stroke_score(1, 1, 0)

# Example 2: Low Probability
# Arm drift only (Severity 0 unless falls rapidly), LOC incorrect (+1)
# Score = 1
cp_sss_stroke_score(0, 0, 1)
}
