\name{dka_mpm_score}
\alias{dka_mpm_score}
\title{
Diabetic Ketoacidosis Mortality Prediction Model (DKA-MPM) Score
}
\description{
Calculates the DKA-MPM score to predict in-hospital mortality in patients with Diabetic Ketoacidosis (DKA). The score is based on clinical and laboratory variables assessed at presentation and during the first 24 hours of admission.
}
\usage{
dka_mpm_score(severe_comorbidities, ph_lt_7, insulin_req_gt_50,
              glucose_gt_300_12hr, depressed_mental_status, fever_24hr)
}
\arguments{
  \item{severe_comorbidities}{
Numeric (0 or 1). Presence of severe comorbidities (e.g., immunosuppression, cancer, renal failure). (1 = Yes, +6 points).
}
  \item{ph_lt_7}{
Numeric (0 or 1). Arterial pH < 7.0 at presentation. (1 = Yes, +4 points).
}
  \item{insulin_req_gt_50}{
Numeric (0 or 1). Requirement of > 50 units of regular insulin in the first 12 hours. (1 = Yes, +4 points).
}
  \item{glucose_gt_300_12hr}{
Numeric (0 or 1). Serum glucose > 300 mg/dL (16.7 mmol/L) after 12 hours of treatment. (1 = Yes, +4 points).
}
  \item{depressed_mental_status}{
Numeric (0 or 1). Depressed mental status (e.g., lethargy, stupor, coma) after 24 hours. (1 = Yes, +4 points).
}
  \item{fever_24hr}{
Numeric (0 or 1). Presence of fever (> 38 C) after 24 hours. (1 = Yes, +3 points).
}
}
\value{
A list containing:
\item{DKA_MPM_Score}{The calculated risk score (Range 0-25).}
\item{Risk_Group}{Risk classification (Low vs. High).}
\item{Estimated_Mortality}{Estimated in-hospital mortality percentage.}
}
\references{
Efstathiou SP, Tsioulos DI, Tsiakou AG, et al. A mortality prediction model in diabetic ketoacidosis. Clin Endocrinol (Oxf). 2002;57(5):595-601. doi:10.1046/j.1365-2265.2002.01636.x
}
\examples{

# Example 1: High Risk
# Severe comorbidities (+6), pH < 7 (+4), High Insulin req (+4), Mental status (+4)
# Score = 18 (Note: Cutoff is typically split around 14/19, this falls in between but close to high)
dka_mpm_score(1, 1, 1, 0, 1, 0)

# Example 2: Low Risk
# No risk factors present
# Score = 0
dka_mpm_score(0, 0, 0, 0, 0, 0)
}
