\name{hints_exam_score}
\alias{hints_exam_score}
\title{
HINTS Exam for Acute Vestibular Syndrome
}
\description{
Interprets the HINTS exam (Head Impulse, Nystagmus, Test of Skew) to distinguish between central causes (e.g., stroke) and peripheral causes (e.g., vestibular neuritis) of acute vestibular syndrome. The presence of ANY central sign ("INFARCT" pattern) suggests a central etiology with higher sensitivity than early MRI for posterior fossa stroke.
}
\usage{
hints_exam_score(head_impulse_normal, nystagmus_direction_changing,
                 skew_deviation_present)
}
\arguments{
  \item{head_impulse_normal}{
Numeric (0 or 1). Result of the Head Impulse Test.
1: Normal (No corrective saccade). This is a CENTRAL sign (Worrisome).
0: Abnormal (Corrective saccade present). This is a PERIPHERAL sign (Reassuring).
}
  \item{nystagmus_direction_changing}{
Numeric (0 or 1). Characteristics of spontaneous nystagmus.
1: Direction-changing (gaze-evoked bidirectional). This is a CENTRAL sign.
0: Direction-fixed (unidirectional). This is a PERIPHERAL sign.
}
  \item{skew_deviation_present}{
Numeric (0 or 1). Test of Skew (Cover-Uncover Test).
1: Skew deviation present (vertical refixation). This is a CENTRAL sign.
0: No skew deviation. This is a PERIPHERAL sign.
}
}
\value{
A list containing:
\item{HINTS_Result}{Clinical interpretation (Central vs. Peripheral).}
\item{Recommendation}{Suggested next steps (MRI vs. Supportive care).}
\item{Central_Features_Present}{List of specific alarming findings identified.}
}
\references{
Kattah JC, Talkad AV, Wang DZ, Hsieh YH, Newman-Toker DE. HINTS to diagnose stroke in the acute vestibular syndrome: three-step bedside oculomotor examination more sensitive than early MRI diffusion-weighted imaging. Stroke. 2009;40(11):3504-3510. doi:10.1161/STROKEAHA.109.551234
}
\examples{

# Example 1: Stroke Likely (INFARCT)
# Head Impulse Normal (1), Nystagmus Direction-Changing (1), No Skew (0)
hints_exam_score(1, 1, 0)

# Example 2: Peripheral Vestibulopathy
# Head Impulse Abnormal (0), Nystagmus Fixed (0), No Skew (0)
hints_exam_score(0, 0, 0)
}
