\name{nafcs_score}
\alias{nafcs_score}
\title{
North American Familial Chylomicronemia Score (NAFCS)
}
\description{
Calculates the NAFCS (derived from the Moulin FCS Score) to estimate the likelihood of Familial Chylomicronemia Syndrome (FCS) in patients with severe hypertriglyceridemia. The score assesses clinical history, response to treatment, and the absence of secondary factors to differentiate FCS from Multifactorial Chylomicronemia Syndrome (MCS).
}
\usage{
nafcs_score(fasting_tg_mg_dl, history_pancreatitis, unexplained_abdominal_pain,
            secondary_factors_present, age_onset_lt_40, poor_response_treatment,
            tg_units = "mg/dL")
}
\arguments{
  \item{fasting_tg_mg_dl}{
Numeric. Fasting triglyceride level. Note: The score requires a history of at least three consecutive fasting triglyceride levels > 885 mg/dL (10 mmol/L). This input should be the highest recorded level.
10-20 mmol/L (885-1770 mg/dL): +1 point.
>20 mmol/L (>1770 mg/dL): +3 points.
}
  \item{history_pancreatitis}{
Numeric (0 or 1). History of pancreatitis. (1 = Yes, +1 point).
}
  \item{unexplained_abdominal_pain}{
Numeric (0 or 1). History of recurrent, unexplained abdominal pain. (1 = Yes, +1 point).
}
  \item{secondary_factors_present}{
Numeric (0 or 1). Presence of secondary factors for hypertriglyceridemia (e.g., BMI > 30, diabetes, alcohol use, pregnancy, specific medications). (0 = No secondary factors present, +2 points; 1 = Secondary factors present, 0 points).
}
  \item{age_onset_lt_40}{
Numeric (0 or 1). Age at diagnosis of hypertriglyceridemia < 40 years. (1 = Yes, +1 point).
}
  \item{poor_response_treatment}{
Numeric (0 or 1). History of poor response (<20\% reduction) to standard lipid-lowering therapy (fibrates/statins). (1 = Yes, +1 point).
}
  \item{tg_units}{
String. Units for triglyceride input. Options: "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{NAFCS_Score}{The calculated total score (Range 0-9).}
\item{Interpretation}{Diagnostic likelihood (Unlikely vs. Very Likely).}
}
\references{
Moulin P, Dufour R, Averna M, et al. Identification and diagnosis of patients with familial chylomicronemia syndrome (FCS): Expert panel recommendations and proposal of an "FCS score". Atherosclerosis. 2018;275:265-272. doi:10.1016/j.atherosclerosis.2018.06.814
Paquette M, Ahmed Z, Hegele RA, Baass A. The Familial Chylomicronemia Syndrome Score: Validation of a Clinical Tool for the Diagnosis of Familial Chylomicronemia Syndrome. J Clin Lipidol. 2019.
}
\examples{

# Example 1: High Likelihood
# TG 2000 mg/dL (+3), Pancreatitis (+1), No secondary factors (+2),
# Age <40 (+1), Poor response (+1), Pain (0)
# Score = 3 + 1 + 2 + 1 + 1 = 8 (Borderline/High)
nafcs_score(2000, 1, 0, 0, 1, 1)

# Example 2: Low Likelihood
# TG 900 mg/dL (+1), No pancreatitis, Secondary factors (Diabetes) present (0),
# Age >40 (0), Good response (0)
# Score = 1
nafcs_score(900, 0, 0, 1, 0, 0)
}
