\name{ottawa_ankle_rules}
\alias{ottawa_ankle_rules}
\title{
Ottawa Ankle Rule
}
\description{
Calculates the Ottawa Ankle Rule to determine the need for radiography (X-ray) in patients with acute ankle or midfoot injuries. These rules are highly sensitive (nearly 100\%) for detecting fractures, allowing clinicians to rule out fractures and reduce unnecessary imaging.
}
\usage{
ottawa_ankle_rules(age, pain_malleolar_zone, pain_midfoot_zone,
                   tenderness_distal_tibia_fibula, tenderness_medial_malleolus,
                   tenderness_lateral_malleolus, tenderness_base_5th_metatarsal,
                   tenderness_navicular, inability_to_bear_weight)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Rule applies broadly, though caution < 18 or > 55 in some protocols).
}
  \item{pain_malleolar_zone}{
Numeric (0 or 1). Pain in the malleolar zone? (1 = Yes).
}
  \item{pain_midfoot_zone}{
Numeric (0 or 1). Pain in the midfoot zone? (1 = Yes).
}
  \item{tenderness_distal_tibia_fibula}{
Numeric (0 or 1). Bone tenderness at the posterior edge or tip of the lateral or medial malleolus (distal 6cm)? (1 = Yes). Note: This covers the general distal tenderness criterion.
}
  \item{tenderness_medial_malleolus}{
Numeric (0 or 1). Specific tenderness at the posterior edge or tip of the medial malleolus? (1 = Yes).
}
  \item{tenderness_lateral_malleolus}{
Numeric (0 or 1). Specific tenderness at the posterior edge or tip of the lateral malleolus? (1 = Yes).
}
  \item{tenderness_base_5th_metatarsal}{
Numeric (0 or 1). Bone tenderness at the base of the 5th metatarsal? (1 = Yes).
}
  \item{tenderness_navicular}{
Numeric (0 or 1). Bone tenderness at the navicular? (1 = Yes).
}
  \item{inability_to_bear_weight}{
Numeric (0 or 1). Inability to bear weight both immediately after injury and in the emergency department (4 steps)? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the need for imaging.}
\item{Imaging_Indicated}{Boolean flags for Ankle vs. Foot X-ray necessity.}
}
\references{
Stiell IG, Greenberg GH, McKnight RD, et al. Decision rules for the use of radiography in acute ankle injuries. Refinement and prospective validation. JAMA. 1993;269(9):1127-1132.
}
\examples{

# Example 1: Ankle X-ray Indicated
# Pain in malleolar zone, tenderness at lateral malleolus
ottawa_ankle_rules(30, 1, 0, 0, 0, 1, 0, 0, 0)

# Example 2: Foot X-ray Indicated
# Pain in midfoot, tenderness at base of 5th metatarsal
ottawa_ankle_rules(45, 0, 1, 0, 0, 0, 1, 0, 0)

# Example 3: No X-ray
# Pain but no tenderness or weight bearing issues
ottawa_ankle_rules(25, 1, 1, 0, 0, 0, 0, 0, 0)
}
