\name{rome_iv_cannabinoid_hyperemesis_syndrome}
\alias{rome_iv_cannabinoid_hyperemesis_syndrome}
\title{
Rome IV Diagnostic Criteria for Cannabinoid Hyperemesis Syndrome (CHS)
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Cannabinoid Hyperemesis Syndrome (CHS)**. Diagnosis requires cyclical episodes of vomiting and nausea, chronic cannabis use, relief from symptoms with hot baths/showers, and exclusion of other causes.
}
\usage{
rome_iv_cannabinoid_hyperemesis_syndrome(recurrent_severe_vomiting,
                                         cannabis_use_ge_6mo,
                                         symptoms_relieved_by_hot_bath,
                                         symptom_onset_after_cannabis,
                                         other_conditions_excluded,
                                         symptom_onset_ge_6mo,
                                         symptoms_active_last_3mo)
}
\arguments{
  \item{recurrent_severe_vomiting}{
Numeric (0 or 1). Presence of recurrent, severe nausea and vomiting. (1 = Yes).
}
  \item{cannabis_use_ge_6mo}{
Numeric (0 or 1). History of prolonged and frequent cannabis use (e.g., typically daily/weekly for >= 6 months). (1 = Yes).
}
  \item{symptoms_relieved_by_hot_bath}{
Numeric (0 or 1). Symptoms are relieved by hot baths or showers. (1 = Yes).
}
  \item{symptom_onset_after_cannabis}{
Numeric (0 or 1). Did symptoms start after cannabis use began? (1 = Yes).
}
  \item{other_conditions_excluded}{
Numeric (0 or 1). Have other causes of cyclical vomiting been excluded? (1 = Yes).
}
  \item{symptom_onset_ge_6mo}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3mo}{
Numeric (0 or 1). Have criteria been fulfilled for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Cannabinoid Hyperemesis Syndrome (CHS)" or "Criteria Not Met".}
}
\references{
Stanghellini V, Chan FK, Hasler WL, et al. Gastroduodenal Disorders. Gastroenterology. 2016;150:1380-1392. doi:10.1053/j.gastro.2016.02.011
}
\examples{

# Example 1: Diagnosis Met
# Recurrent vomiting (1), Chronic use (1), Hot bath relief (1),
#Onset after cannabis (1), Exclusions clear, Chronic duration met
rome_iv_cannabinoid_hyperemesis_syndrome(1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (No hot bath relief)
# All criteria met except no symptom relief with hot baths (0)
rome_iv_cannabinoid_hyperemesis_syndrome(1, 1, 0, 1, 1, 1, 1)
}
