\name{rosier_stroke_scale}
\alias{rosier_stroke_scale}
\title{
Recognition of Stroke in the Emergency Room (ROSIER) Scale
}
\description{
Calculates the ROSIER score to help emergency department staff differentiate between acute stroke and stroke mimics. The score assigns points for specific neurological deficits and subtracts points for loss of consciousness or seizure activity, which are more common in mimics.
}
\usage{
rosier_stroke_scale(loss_of_consciousness, seizure_activity,
                    asymmetric_facial_weakness, asymmetric_arm_weakness,
                    asymmetric_leg_weakness, speech_disturbance,
                    visual_field_defect)
}
\arguments{
  \item{loss_of_consciousness}{
Numeric (0 or 1). Has there been loss of consciousness or syncope? (1 = Yes, -1 point).
}
  \item{seizure_activity}{
Numeric (0 or 1). Has there been seizure activity? (1 = Yes, -1 point).
}
  \item{asymmetric_facial_weakness}{
Numeric (0 or 1). Is there new acute asymmetric facial weakness? (1 = Yes, +1 point).
}
  \item{asymmetric_arm_weakness}{
Numeric (0 or 1). Is there new acute asymmetric arm weakness? (1 = Yes, +1 point).
}
  \item{asymmetric_leg_weakness}{
Numeric (0 or 1). Is there new acute asymmetric leg weakness? (1 = Yes, +1 point).
}
  \item{speech_disturbance}{
Numeric (0 or 1). Is there speech disturbance? (1 = Yes, +1 point).
}
  \item{visual_field_defect}{
Numeric (0 or 1). Is there a visual field defect? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{ROSIER_Score}{The calculated total score (Range -2 to +5).}
\item{Likelihood}{Interpretation (Stroke Likely > 0, Unlikely <= 0).}
\item{Test_Characteristics}{Sensitivity and Specificity for the >0 cutoff.}
}
\references{
Nor AM, Davis J, Sen B, et al. The Recognition of Stroke in the Emergency Room (ROSIER) scale: development and validation of a stroke recognition instrument. Lancet Neurol. 2005;4(11):727-734. doi:10.1016/S1474-4422(05)70201-5
}
\examples{

# Example 1: Stroke Likely
# Face weakness (+1), Arm weakness (+1), Speech disturbance (+1)
# Score = 3
rosier_stroke_scale(0, 0, 1, 1, 0, 1, 0)

# Example 2: Stroke Unlikely (Mimic)
# Seizure (-1), LOC (-1), Arm weakness (+1)
# Score = -1
rosier_stroke_scale(1, 1, 0, 1, 0, 0, 0)
}
