\name{scoff_screening_tool}
\alias{scoff_screening_tool}
\title{
SCOFF Questionnaire for Eating Disorders
}
\description{
Calculates the SCOFF score, a 5-question screening tool designed to detect eating disorders (Anorexia Nervosa and Bulimia Nervosa). The acronym stands for Sick, Control, One stone, Fat, Food. A score of 2 or higher indicates a positive screen.
}
\usage{
scoff_screening_tool(make_sick, lost_control, one_stone_loss, believe_fat,
                     food_dominates)
}
\arguments{
  \item{make_sick}{
Numeric (0 or 1). Do you make yourself Sick because you feel uncomfortably full? (1 = Yes).
}
  \item{lost_control}{
Numeric (0 or 1). Do you worry you have lost Control over how much you eat? (1 = Yes).
}
  \item{one_stone_loss}{
Numeric (0 or 1). Have you recently lost more than One stone (14 lbs or 6.35 kg) in a 3-month period? (1 = Yes).
}
  \item{believe_fat}{
Numeric (0 or 1). Do you believe yourself to be Fat when others say you are too thin? (1 = Yes).
}
  \item{food_dominates}{
Numeric (0 or 1). Would you say that Food dominates your life? (1 = Yes).
}
}
\value{
A list containing:
\item{SCOFF_Score}{The calculated total score (Range 0-5).}
\item{Result}{Interpretation of the screen (Positive >= 2).}
}
\references{
Morgan JF, Reid F, Lacey JH. The SCOFF questionnaire: assessment of a new screening tool for eating disorders. BMJ. 1999;319(7223):1467-1468. doi:10.1136/bmj.319.7223.1467
}
\examples{

# Example 1: Positive Screen
# Lost control (1), Food dominates (1) -> Score 2
scoff_screening_tool(0, 1, 0, 0, 1)

# Example 2: Negative Screen
# No positive answers
scoff_screening_tool(0, 0, 0, 0, 0)
}
