\name{steroid_conversion_calculator}
\alias{steroid_conversion_calculator}
\title{
Steroid Conversion Calculator
}
\description{
Calculates the equivalent dose of a target corticosteroid based on the dose of a current corticosteroid. The conversion uses standard equianalgesic ratios to estimate the anti-inflammatory potency equivalent. It also provides pharmacological properties (potency, half-life) for the target steroid.
}
\usage{
steroid_conversion_calculator(current_steroid, current_dose_mg, target_steroid)
}
\arguments{
  \item{current_steroid}{
String. The name of the steroid currently being used. Options: "cortisone", "hydrocortisone", "prednisone", "prednisolone", "triamcinolone", "methylprednisolone", "dexamethasone", "betamethasone".
}
  \item{current_dose_mg}{
Numeric. The dose of the current steroid in milligrams.
}
  \item{target_steroid}{
String. The name of the steroid to convert to. Same options as current_steroid.
}
}
\details{
Equivalency Table (mg):
Cortisone: 25
Hydrocortisone: 20
Prednisone: 5
Prednisolone: 5
Triamcinolone: 4
Methylprednisolone: 4
Dexamethasone: 0.75
Betamethasone: 0.6
}
\value{
A list containing:
\item{Target_Dose_mg}{The calculated equivalent dose of the target steroid.}
\item{Target_Steroid_Info}{A list of pharmacological properties for the target steroid (Anti-inflammatory potency, Mineralocorticoid potency, Duration).}
\item{Conversion_Ratio}{The ratio used for the specific conversion.}
}
\references{
Meikle AW, Tyler FH. Potency and duration of action of glucocorticoids. Am J Med. 1977;63(2):200-207.
Webb R, Singer M. Oxford Handbook of Critical Care. Oxford; New York: Oxford University Press; 2005.
}
\examples{

# Example 1: Convert 10mg Prednisone to Hydrocortisone
# 10 * (20 / 5) = 40 mg
steroid_conversion_calculator("prednisone", 10, "hydrocortisone")

# Example 2: Convert 8mg Dexamethasone to Methylprednisolone
# 8 * (4 / 0.75) = 42.67 mg
steroid_conversion_calculator("dexamethasone", 8, "methylprednisolone")
}
