\name{subtle_anterior_stemi_4_variable}
\alias{subtle_anterior_stemi_4_variable}
\title{
Subtle Anterior STEMI Calculator (4-Variable)
}
\description{
Calculates the 4-Variable score to differentiate between subtle anterior STEMI (LAD occlusion) and Early Repolarization in patients with chest pain and subtle ST-segment elevation. A score greater than or equal to 18.2 predicts STEMI with high sensitivity and specificity.
}
\usage{
subtle_anterior_stemi_4_variable(qtc_ms, qrs_v2_mm, r_wave_v4_mm, ste_60_v3_mm)
}
\arguments{
  \item{qtc_ms}{
Numeric. The computerized QTc interval in milliseconds.
}
  \item{qrs_v2_mm}{
Numeric. The total QRS amplitude in lead V2 in millimeters.
}
  \item{r_wave_v4_mm}{
Numeric. The R-wave amplitude in lead V4 in millimeters.
}
  \item{ste_60_v3_mm}{
Numeric. ST-segment elevation at 60 milliseconds after the J-point in lead V3, measured in millimeters.
}
}
\value{
A list containing:
\item{Score}{The calculated 4-variable model score.}
\item{Interpretation}{Prediction of "Likely Anterior STEMI" or "Likely Early Repolarization" based on the 18.2 cutoff.}
}
\references{
Smith SW, Khalil A, Henry TD, et al. Electrocardiographic differentiation of early repolarization from subtle anterior ST-segment elevation myocardial infarction. Ann Emerg Med. 2012;60(1):45-56.e2. doi:10.1016/j.annemergmed.2012.02.015
}
\examples{

# Example 1: Likely Early Repolarization
# QTc 390ms, QRS V2 25mm, R-wave V4 15mm, STE60 V3 1.5mm
# Score = (0.052*390) - (0.151*25) - (0.268*15) + (1.062*1.5) = 14.08
subtle_anterior_stemi_4_variable(390, 25, 15, 1.5)

# Example 2: Likely Anterior STEMI
# QTc 420ms, QRS V2 10mm, R-wave V4 5mm, STE60 V3 3.0mm
# Score = (0.052*420) - (0.151*10) - (0.268*5) + (1.062*3.0) = 22.18
subtle_anterior_stemi_4_variable(420, 10, 5, 3.0)
}
