\name{timi_ua_nstemi_score}
\alias{timi_ua_nstemi_score}
\title{
TIMI Risk Score for UA/NSTEMI
}
\description{
Calculates the TIMI Risk Score for Unstable Angina (UA) and Non-ST Elevation Myocardial Infarction (NSTEMI). This score estimates the 14-day risk of all-cause mortality, new or recurrent MI, or severe recurrent ischemia requiring urgent revascularization based on seven clinical risk factors.
}
\usage{
timi_ua_nstemi_score(age, risk_factors_cad_ge_3, known_cad_stenosis,
                     aspirin_use_7d, severe_angina_24h, st_deviation,
                     positive_cardiac_marker)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 65 adds 1 point).
}
  \item{risk_factors_cad_ge_3}{
Numeric (0 or 1). Presence of 3 or more risk factors for CAD (Family history, Hypertension, Hypercholesterolemia, Diabetes, Active Smoker). (1 = Yes, +1 point).
}
  \item{known_cad_stenosis}{
Numeric (0 or 1). Known CAD (stenosis >= 50\%). (1 = Yes, +1 point).
}
  \item{aspirin_use_7d}{
Numeric (0 or 1). Aspirin use in the past 7 days. (1 = Yes, +1 point).
}
  \item{severe_angina_24h}{
Numeric (0 or 1). Severe angina (>= 2 episodes in 24 hours). (1 = Yes, +1 point).
}
  \item{st_deviation}{
Numeric (0 or 1). ST-segment deviation >= 0.5 mm. (1 = Yes, +1 point).
}
  \item{positive_cardiac_marker}{
Numeric (0 or 1). Elevated serum cardiac markers (CK-MB or Troponin). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{TIMI_Score}{The calculated total score (Range 0-7).}
\item{Risk_Composite_14_Day}{Estimated percentage risk of the composite outcome (death, new/recurrent MI, or urgent revascularization) at 14 days.}
}
\references{
Antman EM, Cohen M, Bernink PJ, et al. The TIMI risk score for unstable angina/non-ST elevation MI: A method for prognostication and therapeutic decision making. JAMA. 2000;284(7):835-842. doi:10.1001/jama.284.7.835
}
\examples{

# Example 1: High Risk
# 70yo (+1), Aspirin (+1), Severe Angina (+1), ST changes (+1), Positive Troponin (+1)
# Score = 5
timi_ua_nstemi_score(70, 0, 0, 1, 1, 1, 1)

# Example 2: Low Risk
# 50yo, No Hx, No Aspirin, Angina (+1), No ST changes, Negative Troponin
# Score = 1
timi_ua_nstemi_score(50, 0, 0, 0, 1, 0, 0)
}
